/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassMappingTree
implements Serializable {
    private final TreeElement rootElement;
    private final Map classMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public ClassMappingTree() {
        this(null);
    }

    public ClassMappingTree(Object root) {
        this.rootElement = new TreeElement(class$java$lang$Object == null ? (class$java$lang$Object = ClassMappingTree.class$("java.lang.Object")) : class$java$lang$Object, root);
        this.classMap.put(class$java$lang$Object == null ? (class$java$lang$Object = ClassMappingTree.class$("java.lang.Object")) : class$java$lang$Object, this.rootElement);
    }

    public void add(Class clazz, Object value) {
        this.add(clazz, value, false);
    }

    public void add(Class clazz, Object value, boolean replace) {
        if (this.classMap.containsKey(clazz)) {
            TreeElement element = (TreeElement)this.classMap.get(clazz);
            if (replace) {
                element.setTarget(value);
            } else {
                element.addTarget(value);
            }
        } else {
            TreeElement element = new TreeElement(clazz, value);
            TreeElement nearestParent = this.rootElement.getNearestParentElement(clazz);
            if (nearestParent.hasChild()) {
                Iterator children = nearestParent.getChildElements().iterator();
                while (children.hasNext()) {
                    TreeElement child = (TreeElement)children.next();
                    if (!child.isChildOf(clazz)) continue;
                    nearestParent.moveChild(element, child);
                }
            }
            element = nearestParent.addChild(element);
            this.classMap.put(clazz, element);
        }
    }

    public Object getValue(Class clazz) {
        Object[] values = this.getValues(clazz);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Object[] getValues(Class clazz) {
        if (clazz == null) {
            return this.rootElement.getTargets().toArray();
        }
        if (this.classMap.containsKey(clazz)) {
            return ((TreeElement)this.classMap.get(clazz)).getTargets().toArray();
        }
        TreeElement nearestParent = this.rootElement.getNearestParentElement(clazz);
        return nearestParent.getTargets().toArray();
    }

    public void remove(Class clazz, Object value) {
        if (this.classMap.containsKey(clazz)) {
            TreeElement removeElement = (TreeElement)this.classMap.get(clazz);
            removeElement.removeTarget(value);
            if (removeElement.getTargets().size() == 0) {
                this.remove(clazz);
            }
        }
    }

    public void remove(Class clazz) {
        if (!(class$java$lang$Object == null ? (class$java$lang$Object = ClassMappingTree.class$("java.lang.Object")) : class$java$lang$Object).equals(clazz) && this.classMap.containsKey(clazz)) {
            TreeElement removedElement = (TreeElement)this.classMap.remove(clazz);
            removedElement.parent.removeChild(removedElement);
        }
    }

    public void clear() {
        Iterator classes = new HashSet(this.classMap.keySet()).iterator();
        while (classes.hasNext()) {
            Class clazz = (Class)classes.next();
            this.remove(clazz);
        }
    }

    public String toString() {
        return super.toString() + this.classMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TreeElement
    implements Serializable {
        TreeElement parent;
        private Map children;
        Class clazz;
        private List targets = new ArrayList();

        public TreeElement(Class clazz, Object target) {
            this(null, clazz, target);
        }

        public TreeElement(TreeElement parent, Class clazz, Object target) {
            this.parent = parent;
            this.clazz = clazz;
            this.setTarget(target);
        }

        public TreeElement addChild(TreeElement child) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            if (this.children.containsKey(child.clazz)) {
                TreeElement element = (TreeElement)this.children.get(child.clazz);
                element.addTargets(child.getTargets());
                return element;
            }
            this.children.put(child.clazz, child);
            child.parent = this;
            return child;
        }

        public TreeElement getChild(Class clazz) {
            if (this.children == null) {
                return null;
            }
            return (TreeElement)this.children.get(clazz);
        }

        public Collection getChildElements() {
            return this.children == null ? null : new HashSet(this.children.values());
        }

        public int childrenNumber() {
            return this.children == null ? 0 : this.children.size();
        }

        public void moveChild(TreeElement newParent, TreeElement child) {
            this.children.remove(child.clazz);
            newParent.addChild(child);
        }

        public void removeChild(TreeElement child) {
            TreeElement removedChild = (TreeElement)this.children.remove(child.clazz);
            if (removedChild != null && removedChild.hasChild() && this.parent != null && this.parent.children != null) {
                this.parent.children.putAll(removedChild.children);
            }
        }

        public void setTarget(Object target) {
            this.targets.clear();
            if (target != null) {
                this.targets.add(target);
            }
        }

        public void addTarget(Object target) {
            if (target != null) {
                this.targets.add(target);
            }
        }

        public void addTargets(List targets) {
            targets.addAll(targets);
        }

        public List getTargets() {
            return this.targets;
        }

        public void removeTarget(Object target) {
            this.targets.remove(target);
        }

        public boolean hasChild() {
            return this.children != null && this.children.size() != 0;
        }

        public TreeElement getNearestParentElement(Class clazz) {
            if (!this.isParentOf(clazz)) {
                return null;
            }
            if (!this.hasChild()) {
                return this;
            }
            TreeElement nearestElement = null;
            Iterator elements = this.children.values().iterator();
            while (elements.hasNext()) {
                TreeElement element = (TreeElement)elements.next();
                nearestElement = element.getNearestParentElement(clazz);
                if (nearestElement == null) continue;
                return nearestElement;
            }
            return this;
        }

        public boolean isChildOf(Class clazz) {
            return clazz.isAssignableFrom(this.clazz);
        }

        public boolean isParentOf(Class clazz) {
            return this.clazz.isAssignableFrom(clazz);
        }

        public Object getTarget() {
            return this.targets.size() == 0 ? null : this.targets.get(0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TreeElement)) {
                return false;
            }
            TreeElement element = (TreeElement)obj;
            if (this.clazz == null) {
                return element.clazz == null;
            }
            return this.clazz.equals(element.clazz);
        }

        public int hashCode() {
            return this.clazz == null ? 0 : this.clazz.hashCode();
        }

        public String toString() {
            return this.targets.toString();
        }
    }
}

