/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.db.DatabaseWriterServiceMBean;

public class DatabaseWriterService
extends ServiceBase
implements DatabaseWriterServiceMBean,
Serializable {
    private static final String DBW__ = "DBW__";
    private static final String DBW__0 = "DBW__0";
    private static final String DBW__00 = "DBW__00";
    private static final String DBW__000 = "DBW__000";
    private static final String DBW__0000 = "DBW__0000";
    private static final String DBW__00001 = "DBW__00001";
    private static final String DBW__00002 = "DBW__00002";
    private Properties insertSQLs;
    private List insertSQLList;
    private int bufferSize;
    private List recordBuffer;
    private long bufferTimeout;
    private Timer bufferTimeoutTimer;
    private TimerTask bufferTimeoutTimerTask;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;

    public void setInsertSQL(Properties sqls) {
        this.insertSQLs = sqls;
    }

    public Properties getInsertSQL() {
        return this.insertSQLs;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferTimeout(long timeout) {
        this.bufferTimeout = timeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void createService() throws Exception {
        this.insertSQLList = new ArrayList();
        this.recordBuffer = new ArrayList();
    }

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ConnectionFactoryServiceName is null");
        }
        this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        if (this.insertSQLs == null) {
            throw new IllegalArgumentException("InsertSQL is null");
        }
        Iterator<Object> sqls = this.insertSQLs.keySet().iterator();
        while (sqls.hasNext()) {
            String sql = (String)sqls.next();
            this.insertSQLList.add(new InsertSQL(sql, this.insertSQLs.getProperty(sql)));
        }
        if (this.bufferTimeout > 0L && this.bufferSize > 0) {
            this.bufferTimeoutTimer = new Timer(true);
        }
    }

    public void stopService() throws Exception {
        if (this.bufferTimeoutTimer != null) {
            this.bufferTimeoutTimer.cancel();
            this.bufferTimeoutTimer = null;
            this.bufferTimeoutTimerTask = null;
        }
        if (this.bufferSize > 0 && this.recordBuffer.size() > 0) {
            this.writeBatch();
        }
        this.recordBuffer.clear();
        this.insertSQLList.clear();
        this.connectionFactory = null;
    }

    public void destroyService() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(WritableRecord rec) throws MessageWriteException {
        if (this.getState() != 3) {
            return;
        }
        Logger logger = this.getLogger();
        if (this.bufferSize <= 0) {
            List list = this.insertSQLList;
            synchronized (list) {
                block32: {
                    Connection conn = null;
                    conn = this.connectionFactory.getConnection();
                    Map elementMap = rec.getElementMap();
                    Iterator insertSQLs = this.insertSQLList.iterator();
                    while (insertSQLs.hasNext()) {
                        InsertSQL sql = (InsertSQL)insertSQLs.next();
                        try {
                            sql.open(conn);
                            if (sql.keyList != null) {
                                int max = sql.keyList.size();
                                for (int i = 0; i < max; ++i) {
                                    WritableElement element = (WritableElement)elementMap.get(sql.keyList.get(i));
                                    sql.statement.setObject(i + 1, element.getValue());
                                }
                            }
                            sql.statement.executeUpdate();
                        }
                        finally {
                            try {
                                sql.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                    conn.commit();
                    Object var14_18 = null;
                    if (conn == null) break block32;
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    conn = null;
                    {
                        break block32;
                        catch (SQLException e) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException ex) {
                                // empty catch block
                            }
                            logger.write(DBW__00001, e);
                            throw new MessageWriteException(e);
                        }
                        catch (ConnectionFactoryException e) {
                            logger.write(DBW__00002, e);
                            throw new MessageWriteException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                if (this.bufferTimeoutTimerTask == null) {
                    this.bufferTimeoutTimerTask = new TimerTask(){

                        public void run() {
                            try {
                                DatabaseWriterService.this.writeBatch();
                            }
                            catch (MessageWriteException messageWriteException) {
                                // empty catch block
                            }
                        }
                    };
                    this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                }
            }
        }
        this.recordBuffer.add(rec);
        if (this.recordBuffer.size() >= this.bufferSize) {
            this.writeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeBatch() throws MessageWriteException {
        Object object;
        Logger logger = this.getLogger();
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask != null) {
            object = this.bufferTimeoutTimer;
            synchronized (object) {
                this.bufferTimeoutTimerTask.cancel();
                this.bufferTimeoutTimerTask = null;
            }
        }
        object = this.insertSQLList;
        synchronized (object) {
            block38: {
                Connection conn = null;
                conn = this.connectionFactory.getConnection();
                Iterator insertSQLs = this.insertSQLList.iterator();
                while (insertSQLs.hasNext()) {
                    SQLException e2222;
                    Object var14_18;
                    InsertSQL sql = (InsertSQL)insertSQLs.next();
                    try {
                        sql.open(conn);
                        Iterator recs = this.recordBuffer.iterator();
                        int count = 0;
                        while (recs.hasNext()) {
                            WritableRecord rec = (WritableRecord)recs.next();
                            Map elementMap = rec.getElementMap();
                            if (sql.keyList != null) {
                                int max = sql.keyList.size();
                                for (int i = 0; i < max; ++i) {
                                    WritableElement element = (WritableElement)elementMap.get(sql.keyList.get(i));
                                    sql.statement.setObject(i + 1, element.getValue());
                                }
                            }
                            sql.statement.addBatch();
                            if (++count < this.bufferSize) continue;
                            break;
                        }
                        sql.statement.executeBatch();
                        var14_18 = null;
                    }
                    catch (Throwable throwable) {
                        var14_18 = null;
                        try {
                            sql.statement.clearBatch();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                        try {
                            sql.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        sql.statement.clearBatch();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                    try {
                        sql.close();
                    }
                    catch (SQLException e2222) {}
                }
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.recordBuffer.remove(i);
                }
                conn.commit();
                Object var17_21 = null;
                if (conn == null) break block38;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                conn = null;
                {
                    break block38;
                    catch (SQLException e) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        logger.write(DBW__00001, e);
                        throw new MessageWriteException(e);
                    }
                    catch (ConnectionFactoryException e) {
                        logger.write(DBW__00002, e);
                        throw new MessageWriteException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        conn = null;
                    }
                    throw throwable;
                }
            }
        }
        if (this.recordBuffer.size() >= this.bufferSize) {
            this.writeBatch();
        }
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null && this.recordBuffer.size() != 0) {
            object = this.bufferTimeoutTimer;
            synchronized (object) {
                if (this.bufferTimeoutTimerTask == null) {
                    this.bufferTimeoutTimerTask = new TimerTask(){

                        public void run() {
                            try {
                                DatabaseWriterService.this.writeBatch();
                            }
                            catch (MessageWriteException messageWriteException) {
                                // empty catch block
                            }
                        }
                    };
                    this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                }
            }
        }
    }

    protected static class InsertSQL
    implements Serializable {
        PreparedStatement statement;
        List keyList;
        private String statementString;

        public InsertSQL(String stm, String keys) throws SQLException, IllegalArgumentException {
            this.statementString = stm;
            if (keys.length() == 0) {
                return;
            }
            this.keyList = new ArrayList();
            boolean isEscape = false;
            StringBuffer buf = new StringBuffer();
            int max = keys.length();
            block4: for (int i = 0; i < max; ++i) {
                char c = keys.charAt(i);
                switch (c) {
                    case '\\': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        isEscape = true;
                        continue block4;
                    }
                    case ',': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        this.keyList.add(buf.toString());
                        buf.setLength(0);
                        continue block4;
                    }
                    default: {
                        if (isEscape) {
                            throw new IllegalArgumentException("'\\' is escape character. : " + keys);
                        }
                        buf.append(c);
                    }
                }
            }
            if (isEscape) {
                throw new IllegalArgumentException("'\\' is escape character. : " + keys);
            }
            if (buf.length() != 0) {
                this.keyList.add(buf.toString());
                buf.setLength(0);
            }
        }

        public void open(Connection con) throws SQLException {
            this.statement = con.prepareStatement(this.statementString);
        }

        public void close() throws SQLException {
            this.statement.close();
            this.statement = null;
        }
    }
}

