/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.PrintStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.writer.ConsoleWriterServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class ConsoleWriterService
extends ServiceBase
implements ConsoleWriterServiceMBean,
MessageWriter {
    public static final String OUTPUT_STDOUT = "STDOUT";
    public static final String OUTPUT_STDERR = "STDERR";
    private String mOutputKind = "STDOUT";
    PrintStream mOutputStream;

    public void setOutput(String kind) {
        this.mOutputKind = kind.equals(OUTPUT_STDERR) ? kind : OUTPUT_STDOUT;
    }

    public String getOutput() {
        return this.mOutputKind;
    }

    public void startService() {
        this.mOutputStream = this.mOutputKind.equals(OUTPUT_STDERR) ? System.err : System.out;
    }

    public void stopService() {
        this.mOutputStream = null;
    }

    public void write(WritableRecord rec) {
        this.mOutputStream.println(rec.toString());
    }
}

