/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected List sleepThreads = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResource(long timeOutMiliSecond) {
        boolean bRet = false;
        long timeOutMs = -1L;
        boolean isTimeout = false;
        if (timeOutMiliSecond >= 0L) {
            timeOutMs = timeOutMiliSecond;
        }
        Thread current = Thread.currentThread();
        long processTime = 0L;
        while (timeOutMs <= 0L || timeOutMs > processTime) {
            if (this.mFourceEndFlg) {
                return false;
            }
            while (this.mResourceCnt == 0 && timeOutMs > processTime) {
                long proc = System.currentTimeMillis();
                this.sleepThreads.add(current);
                try {
                    Thread.sleep(timeOutMs > 0L ? timeOutMs - processTime : 500L);
                    proc = System.currentTimeMillis() - proc;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    if (this.sleepThreads.contains(current) && this.mResourceCnt == 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this.sleepThreads.remove(current);
                }
                if (timeOutMs <= 0L) continue;
                processTime += proc;
            }
            if (this.mResourceCnt > 0) {
                --this.mResourceCnt;
                return true;
            }
            if (!this.mFourceEndFlg) continue;
            return false;
        }
        return false;
    }

    public boolean getResource() {
        return this.getResource(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResource() {
        if (this.mResourceCnt < this.mInitialResource) {
            ++this.mResourceCnt;
        }
        Thread sleepThread = null;
        List list = this.sleepThreads;
        synchronized (list) {
            if (this.sleepThreads.size() != 0) {
                sleepThread = (Thread)this.sleepThreads.remove(0);
            }
        }
        if (sleepThread != null) {
            sleepThread.interrupt();
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceRemain() {
        int cnt;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            cnt = this.mResourceCnt;
        }
        return cnt;
    }

    public void stop() {
        this.mFourceEndFlg = true;
        while (this.sleepThreads.size() != 0) {
            this.freeResource();
        }
    }
}

