/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jmsqueue;

import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class QueueTransanctionResource
implements TransactionResource {
    private QueueSession mSession = null;
    private QueueConnection mQueueConnection = null;
    private Semaphore mSemaphore;

    QueueTransanctionResource(QueueSession session, QueueConnection conn, Semaphore sem) {
        this.mSession = session;
        this.mQueueConnection = conn;
        this.mSemaphore = sem;
    }

    public void commit() throws JMSException {
        if (this.mSession.getTransacted()) {
            this.mSession.commit();
        }
    }

    public void rollback() throws JMSException {
        if (this.mSession.getTransacted()) {
            this.mSession.rollback();
        }
    }

    public void close() throws JMSException {
        this.mSession.close();
        if (this.mSemaphore != null) {
            this.mSemaphore.freeResource();
        }
    }

    public Object getObject() {
        return this.mSession;
    }

    public QueueConnection getConnectionObject() {
        return this.mQueueConnection;
    }
}

