/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jmsqueue;

import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.JmsQueueSession;
import jp.ossc.nimbus.service.resource.jmsqueue.JmsQueueSessionServiceMBean;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.semaphore.SemaphoreFactory;

public class JmsQueueSessionService
extends ServiceBase
implements JmsQueueSessionServiceMBean,
JmsQueueSession {
    private JndiFinder mJndiFinderService = null;
    private ServiceName mJndiFinderServiceName = null;
    private int mAckMode = 1;
    private boolean mTransanctionMode = false;
    private QueueConnectionFactory mQueueConnectionFactory;
    private ServiceName mSemaphoreFactoryServiceName;
    private SemaphoreFactory mSemaphoreFactory;
    private Semaphore mSemaphore;
    private QueueConnection mConnection;
    private int mSemaphoreCapacity;
    private String userName;
    private String password;
    private String queueConnectionFactoryName;

    public void setSemaphoreFactoryServiceName(ServiceName name) {
        this.mSemaphoreFactoryServiceName = name;
    }

    public void setCapacity(int capa) {
        this.mSemaphoreCapacity = capa;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void startService() throws Exception {
        this.mJndiFinderService = (JndiFinder)((Object)ServiceManagerFactory.getService(this.mJndiFinderServiceName));
        if (this.mSemaphoreFactoryServiceName != null) {
            this.mSemaphoreFactory = (SemaphoreFactory)((Object)ServiceManagerFactory.getService(this.mSemaphoreFactoryServiceName));
        }
        try {
            this.mQueueConnectionFactory = this.queueConnectionFactoryName == null ? (QueueConnectionFactory)this.mJndiFinderService.lookup() : (QueueConnectionFactory)this.mJndiFinderService.lookup(this.queueConnectionFactoryName);
        }
        catch (NamingException e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE013", "Fail to lookup QueueConnectionFactory", e);
        }
        catch (ClassCastException e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE014", "found resource is not QueueConnectionFactory.", e);
        }
        try {
            this.mConnection = this.userName != null ? this.mQueueConnectionFactory.createQueueConnection(this.userName, this.password) : this.mQueueConnectionFactory.createQueueConnection();
        }
        catch (Exception e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE015", "Fail to Create Connection.", e);
        }
        if (this.mSemaphoreFactory != null) {
            this.mSemaphore = this.mSemaphoreFactory.createSemaphore(this.mSemaphoreCapacity);
        }
    }

    public void stopService() {
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mSemaphore = null;
    }

    public void destory() {
        this.mJndiFinderService = null;
    }

    public void setAcknowledgeMode(int mode) {
        if (mode == 1 || mode == 2 || mode == 3) {
            this.mAckMode = mode;
        }
    }

    public int getAcknowledgeMode() {
        return this.mAckMode;
    }

    public void setTransanctionMode(boolean mode) {
        this.mTransanctionMode = mode;
    }

    public boolean getTransanctionMode() {
        return this.mTransanctionMode;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setQueueConnectionFactoryName(String name) {
        this.queueConnectionFactoryName = name;
    }

    public String getQueueConnectionFactoryName() {
        return this.queueConnectionFactoryName;
    }

    public TransactionResource makeResource(String key) throws JMSException {
        if (this.mSemaphore != null) {
            this.mSemaphore.getResource(-1L);
        }
        QueueSession qSession = this.mConnection.createQueueSession(this.mTransanctionMode, this.mAckMode);
        QueueTransanctionResource tranObj = new QueueTransanctionResource(qSession, this.mConnection, this.mSemaphore);
        return tranObj;
    }
}

