/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultQueueService
extends ServiceBase
implements Queue,
CacheRemoveListener,
DefaultQueueServiceMBean,
Serializable {
    private List queueElements;
    private volatile boolean forceEndFlg = false;
    private int initialCapacity = -1;
    private int capacityIncrement = -1;
    private ServiceName cacheServiceName;
    private Cache cache;
    private List sleepThreads;
    private volatile boolean fourceEndFlg = false;

    public void setInitialCapacity(int initial) {
        this.initialCapacity = initial;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    public void createService() throws Exception {
        this.sleepThreads = new Vector();
    }

    public void startService() throws Exception {
        this.fourceEndFlg = false;
        if (this.queueElements == null) {
            this.queueElements = this.initialCapacity >= 0 ? (this.capacityIncrement >= 0 ? new Vector(this.initialCapacity, this.capacityIncrement) : new Vector(this.initialCapacity)) : new Vector();
        }
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        this.fourceEndFlg = true;
        if (this.sleepThreads != null) {
            while (true) {
                Thread sleepThread = null;
                List list = this.sleepThreads;
                synchronized (list) {
                    if (this.sleepThreads.size() == 0) {
                        break;
                    }
                    sleepThread = (Thread)this.sleepThreads.remove(0);
                }
                sleepThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() throws Exception {
        this.queueElements.clear();
        this.queueElements = null;
        this.cache = null;
        List list = this.sleepThreads;
        synchronized (list) {
            this.sleepThreads = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        if (this.cache == null) {
            this.queueElements.add(item);
        } else {
            CachedReference ref = this.cache.add(item);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(item);
            }
        }
        if (this.sleepThreads != null) {
            List list = this.sleepThreads;
            synchronized (list) {
                if (this.sleepThreads.size() != 0) {
                    ((Thread)this.sleepThreads.remove(0)).interrupt();
                }
            }
        }
    }

    public Object get(int timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(int timeOutMs, boolean isRemove) {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        Thread current = Thread.currentThread();
        long processTime = 0L;
        do {
            long proc;
            block17: {
                Object var11_7;
                if (timeOutMs >= 0) {
                    if ((long)timeOutMs <= processTime) return this.getQueueElement(isRemove);
                }
                if (this.size() != 0) return this.getQueueElement(isRemove);
                if (this.fourceEndFlg) return this.getQueueElement(isRemove);
                if (this.fourceEndFlg) {
                    return null;
                }
                proc = 0L;
                if (timeOutMs >= 0) {
                    proc = System.currentTimeMillis();
                }
                try {
                    block16: {
                        try {
                            if (this.sleepThreads != null) {
                                this.sleepThreads.add(current);
                            }
                            if (timeOutMs >= 0) {
                                Thread.sleep((long)timeOutMs - processTime);
                            } else {
                                Thread.sleep(500L);
                            }
                            if (timeOutMs < 0) break block16;
                            proc = System.currentTimeMillis() - proc;
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            if (this.sleepThreads != null && this.sleepThreads.contains(current) && this.queueElements != null && this.size() == 0) {
                                Object var9_8 = null;
                                var11_7 = null;
                                if (this.sleepThreads == null) return var9_8;
                                this.sleepThreads.remove(current);
                                return var9_8;
                            }
                            var11_7 = null;
                            if (this.sleepThreads != null) {
                                this.sleepThreads.remove(current);
                            }
                            break block17;
                        }
                    }
                    var11_7 = null;
                    if (this.sleepThreads != null) {
                        this.sleepThreads.remove(current);
                    }
                }
                catch (Throwable throwable) {
                    var11_7 = null;
                    if (this.sleepThreads == null) throw throwable;
                    this.sleepThreads.remove(current);
                    throw throwable;
                }
            }
            if (timeOutMs >= 0) {
                processTime += proc;
            }
            if (this.queueElements == null || this.size() <= 0) continue;
            return this.getQueueElement(isRemove);
        } while (!this.fourceEndFlg);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.queueElements == null || this.size() == 0) {
            return null;
        }
        Object element = null;
        List list = this.queueElements;
        synchronized (list) {
            if (this.size() != 0) {
                element = isRemove ? this.queueElements.remove(0) : this.queueElements.get(0);
            }
        }
        if (element == null) {
            return null;
        }
        if (this.cache == null) {
            return element;
        }
        if (element instanceof CachedReference) {
            CachedReference ref = element;
            if (ref != null) {
                Object obj = ref.get();
                if (isRemove) {
                    this.cache.remove(ref);
                }
                return obj;
            }
            return null;
        }
        return element;
    }

    public Object get() {
        return this.get(-1);
    }

    public Object peek(int timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    public Object peek() {
        return this.peek(-1);
    }

    public void remove(Object item) {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        if (this.cache == null) {
            this.queueElements.remove(item);
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (element instanceof CachedReference) {
                    CachedReference ref = (CachedReference)element;
                    Object obj = ref.get(this, false);
                    if ((item != null || obj != null) && (item == null || !item.equals(obj))) continue;
                    this.cache.remove(ref);
                    break;
                }
                if ((item != null || element != null) && (item == null || !item.equals(element))) continue;
                this.queueElements.remove(element);
                break;
            }
        }
    }

    public void clear() {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        if (this.cache == null) {
            this.queueElements.clear();
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (!(element instanceof CachedReference)) continue;
                CachedReference ref = (CachedReference)element;
                this.cache.remove(ref);
            }
            this.queueElements.clear();
        }
    }

    public synchronized int size() {
        if (this.queueElements == null) {
            return 0;
        }
        return this.queueElements.size();
    }

    public List getElements() {
        if (this.queueElements == null) {
            return new ArrayList();
        }
        return new ArrayList(this.queueElements);
    }

    public void removed(CachedReference ref) {
        if (this.queueElements == null) {
            return;
        }
        this.queueElements.remove(ref);
    }
}

