/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.performance.CachedPerformanceStatisticsServiceMBean;
import jp.ossc.nimbus.service.performance.PerformanceRecord;
import jp.ossc.nimbus.service.performance.PerformanceRecordOperator;
import jp.ossc.nimbus.service.performance.PerformanceStatistics;
import jp.ossc.nimbus.util.CsvArrayList;

public class CachedPerformanceStatisticsService
extends ServiceBase
implements PerformanceStatistics,
CachedPerformanceStatisticsServiceMBean {
    protected Hashtable mHash = null;
    protected String mClassName = null;
    protected Class mClsRec = null;

    public void createService() {
        this.mHash = new Hashtable(1024, 256.0f);
    }

    public void stopService() {
        this.mHash.clear();
    }

    public void destroyService() {
        this.mHash = null;
        this.mClassName = null;
        this.mClsRec = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(String key, long msec) {
        CachedPerformanceStatisticsService cachedPerformanceStatisticsService = this;
        synchronized (cachedPerformanceStatisticsService) {
            PerformanceRecordOperator performanceObj = null;
            performanceObj = (PerformanceRecordOperator)this.mHash.get(key);
            if (performanceObj != null) {
                performanceObj.entry(msec);
            } else {
                try {
                    performanceObj = (PerformanceRecordOperator)this.mClsRec.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ServiceException("PEFORMANCE001", "InstantiationException", e);
                }
                catch (IllegalAccessException e) {
                    throw new ServiceException("PEFORMANCE001", "IllegalAccessException", e);
                }
                performanceObj.setResourceId(key);
                performanceObj.entry(msec);
                this.mHash.put(key, performanceObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CachedPerformanceStatisticsService cachedPerformanceStatisticsService = this;
        synchronized (cachedPerformanceStatisticsService) {
            this.mHash.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] toStringAry(int sortKey, boolean isUpset) {
        Boolean log = new Boolean(isUpset);
        ArrayList sortList = new ArrayList();
        CsvArrayList retAry = new CsvArrayList();
        Hashtable tb = null;
        CachedPerformanceStatisticsService cachedPerformanceStatisticsService = this;
        synchronized (cachedPerformanceStatisticsService) {
            tb = (Hashtable)this.mHash.clone();
        }
        Object object = tb.elements();
        while (object.hasMoreElements()) {
            PerformanceRecord item = (PerformanceRecord)object.nextElement();
            this._sortList(sortList, item, sortKey, isUpset);
        }
        object = sortList.listIterator();
        while (object.hasNext()) {
            String sortItem = (String)object.next();
            CsvArrayList keyAry = new CsvArrayList();
            keyAry.split(sortItem, ";");
            PerformanceRecord item = (PerformanceRecord)this.mHash.get(keyAry.getStr(0));
            if (item == null) continue;
            retAry.add(((Object)item).toString());
        }
        String[] retStrAry = retAry.toStringAry();
        return retStrAry;
    }

    private void _sortList(ArrayList sortList, PerformanceRecord item, int sortKey, boolean isUpset) {
        Long tmpLong;
        String strlog1 = null;
        String strlog2 = null;
        if (sortList != null) {
            strlog1 = sortList.toString();
        }
        if (item != null) {
            strlog2 = ((Object)item).toString();
        }
        Boolean booleanlog = new Boolean(isUpset);
        String cmpKey = null;
        if (sortKey == 0) {
            cmpKey = item.getResourceId();
        } else if (sortKey == 1) {
            tmpLong = new Long(item.getBestPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 2) {
            tmpLong = new Long(item.getWorstPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 3) {
            tmpLong = new Long(item.getAveragePerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 4) {
            tmpLong = new Long(item.getCallTime());
            cmpKey = tmpLong.toString();
        }
        String rscId = item.getResourceId() + ";" + cmpKey;
        int entryCnt = 0;
        ListIterator listIterator = sortList.listIterator();
        while (listIterator.hasNext()) {
            String destCmp = (String)listIterator.next();
            CsvArrayList parse = new CsvArrayList();
            parse.split(destCmp, ";");
            int ret = cmpKey.compareTo(parse.getStr(1));
            if (isUpset ? ret <= 0 : ret >= 0) break;
            ++entryCnt;
        }
        sortList.add(entryCnt, rscId);
    }

    private void _sortListByVal(ArrayList sortList, PerformanceRecord item, int sortKey, boolean isUpset) {
        Long tmpLong;
        String strlog1 = null;
        String strlog2 = null;
        if (sortList != null) {
            strlog1 = sortList.toString();
        }
        if (item != null) {
            strlog2 = ((Object)item).toString();
        }
        String cmpKey = null;
        if (sortKey == 0) {
            cmpKey = item.getResourceId();
        } else if (sortKey == 1) {
            tmpLong = new Long(item.getBestPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 2) {
            tmpLong = new Long(item.getWorstPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 3) {
            tmpLong = new Long(item.getAveragePerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 4) {
            tmpLong = new Long(item.getCallTime());
            cmpKey = tmpLong.toString();
        }
        String rscId = item.getResourceId() + ";" + cmpKey;
        int entryCnt = 0;
        ListIterator listIterator = sortList.listIterator();
        while (listIterator.hasNext()) {
            String destCmp = (String)listIterator.next();
            CsvArrayList parse = new CsvArrayList();
            parse.split(destCmp, ";");
            int ret = 0;
            if (sortKey == 0) {
                ret = cmpKey.compareTo(parse.getStr(1));
            } else {
                long value = Long.valueOf(parse.getStr(1));
                long cmpvalue = Long.valueOf(cmpKey);
                ret = cmpvalue == value ? 0 : (cmpvalue < value ? -1 : 1);
            }
            if (isUpset ? ret <= 0 : ret >= 0) break;
            ++entryCnt;
        }
        sortList.add(entryCnt, rscId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList toAry(int sortKey, boolean isUpset) {
        ArrayList sortList = new ArrayList();
        ArrayList<PerformanceRecord> retAry = new ArrayList<PerformanceRecord>();
        Hashtable tb = null;
        CachedPerformanceStatisticsService cachedPerformanceStatisticsService = this;
        synchronized (cachedPerformanceStatisticsService) {
            tb = (Hashtable)this.mHash.clone();
        }
        Object object = tb.elements();
        while (object.hasMoreElements()) {
            PerformanceRecord item = (PerformanceRecord)object.nextElement();
            if (sortKey == 0) {
                this._sortList(sortList, item, sortKey, isUpset);
                continue;
            }
            this._sortListByVal(sortList, item, sortKey, isUpset);
        }
        object = sortList.listIterator();
        while (object.hasNext()) {
            String sortItem = (String)object.next();
            CsvArrayList keyAry = new CsvArrayList();
            keyAry.split(sortItem, ";");
            PerformanceRecord item = (PerformanceRecord)this.mHash.get(keyAry.getStr(0));
            if (item == null) continue;
            retAry.add(item);
        }
        return retAry;
    }

    public void setRecordClassName(String className) {
        this.mClassName = className;
        try {
            this.mClsRec = Class.forName(className, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("PEFORMANCE010", "ClassNotFoundException classnamse = " + className, e);
        }
    }

    public String getRecordClassName() {
        return this.mClassName;
    }
}

