/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.RegistrationEvent;
import jp.ossc.nimbus.core.RegistrationListener;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.log.CommonsLogFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class NimbusLogFactory
extends LogFactory {
    public static final String DEFAULT_FACTORY_PROPERTY = "jp.ossc.nimbus.service.log.NimbusLogFactory.DefaultLogFactory";
    public static final String FACTORY_NAME_PROPERTY = "jp.ossc.nimbus.service.log.NimbusLogFactory.CommonsLogFactoryName";
    public static final String DEFAULT_FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    private CommonsLogFactory logFactory;
    private LogFactory deafultLogFactory;
    private Map attributes = new HashMap();
    private Map logInstances = new HashMap();

    public void setCommonsLogFactory(CommonsLogFactory factory) {
        if (this.logFactory != null && this.logFactory == factory) {
            return;
        }
        this.logFactory = factory;
        if (factory != null) {
            String[] names = this.getAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                factory.setAttribute(name, this.getAttribute(name));
            }
        }
        Iterator logKeys = this.logInstances.keySet().iterator();
        while (logKeys.hasNext()) {
            Object key = logKeys.next();
            LogWrapper log = (LogWrapper)this.logInstances.get(key);
            if (factory != null) {
                if (key instanceof Class) {
                    log.setRealLog(factory.getInstance((Class)key));
                } else {
                    log.setRealLog(factory.getInstance((String)key));
                }
                log.real();
                continue;
            }
            log.dummy();
        }
    }

    private Log getInstance(Object key) {
        if (this.logInstances.containsKey(key)) {
            return (Log)this.logInstances.get(key);
        }
        if (this.deafultLogFactory == null) {
            this.deafultLogFactory = this.createDefaultLogFactory();
        }
        LogWrapper log = null;
        if (this.logFactory != null) {
            log = key instanceof Class ? new LogWrapper(this.logFactory.getInstance((Class)key), this.deafultLogFactory.getInstance((Class)key)) : new LogWrapper(this.logFactory.getInstance((String)key), this.deafultLogFactory.getInstance((String)key));
            this.logInstances.put(key, log);
            return log;
        }
        Object factory = null;
        String factoryName = System.getProperty(FACTORY_NAME_PROPERTY);
        if (factoryName == null) {
            factoryName = (String)this.getAttribute(FACTORY_NAME_PROPERTY);
        }
        if (factoryName == null) {
            log = key instanceof Class ? new LogWrapper(this.deafultLogFactory.getInstance((Class)key)) : new LogWrapper(this.deafultLogFactory.getInstance((String)key));
            this.logInstances.put(key, log);
            return log;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(factoryName);
        ServiceName name = (ServiceName)editor.getValue();
        LogWrapper tmpLog = null;
        tmpLog = key instanceof Class ? new LogWrapper(this.deafultLogFactory.getInstance((Class)key)) : new LogWrapper(this.deafultLogFactory.getInstance((String)key));
        log = tmpLog;
        this.logInstances.put(key, log);
        String managerName = name.getServiceManagerName();
        String serviceName = name.getServiceName();
        if (!ServiceManagerFactory.isRegisteredManager(managerName)) {
            this.waitRegistrationManager(managerName, serviceName);
            return log;
        }
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (!manager.isRegisteredService(serviceName)) {
            this.waitRegistrationService(manager, serviceName);
            return log;
        }
        Service service = manager.getService(serviceName);
        this.waitStartService(service);
        return log;
    }

    private void waitRegistrationManager(final String targetMng, final String targetService) {
        ServiceManagerFactory.addRegistrationListener(new RegistrationListener(){

            public void registered(RegistrationEvent e) {
                ServiceManager manager = (ServiceManager)e.getRegistration();
                if (!manager.getServiceName().equals(targetMng)) {
                    return;
                }
                ServiceManagerFactory.removeRegistrationListener(this);
                Service service = null;
                try {
                    service = manager.getService(targetService);
                }
                catch (ServiceNotFoundException ex) {
                    NimbusLogFactory.this.waitRegistrationService(manager, targetService);
                }
                if (service != null) {
                    NimbusLogFactory.this.waitStartService(service);
                }
            }

            public void unregistered(RegistrationEvent e) {
            }
        });
    }

    private void waitRegistrationService(final ServiceManager targetMng, final String targetService) {
        targetMng.addRegistrationListener(new RegistrationListener(){

            public void registered(RegistrationEvent e) {
                Service service = (Service)e.getRegistration();
                if (!service.getServiceName().equals(targetService)) {
                    return;
                }
                targetMng.removeRegistrationListener(this);
                NimbusLogFactory.this.waitStartService(service);
            }

            public void unregistered(RegistrationEvent e) {
            }
        });
    }

    private void waitStartService(final Service service) {
        Service targetService = null;
        if (!(service instanceof ServiceStateBroadcaster)) {
            String managerName = service.getServiceManagerName();
            ServiceManager mng = ServiceManagerFactory.findManager(managerName);
            targetService = mng;
        } else {
            targetService = service;
        }
        final ServiceStateBroadcaster broad = ServiceManagerFactory.getServiceStateBroadcaster(targetService.getServiceManagerName(), targetService.getServiceName());
        if (broad != null) {
            broad.addServiceStateListener(new ServiceStateListener(){

                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    CommonsLogFactory factory = null;
                    switch (service.getState()) {
                        case 3: {
                            try {
                                factory = (CommonsLogFactory)ServiceManagerFactory.getServiceObject(service.getServiceManagerName(), service.getServiceName());
                            }
                            catch (ServiceNotFoundException ex) {
                                factory = null;
                            }
                            break;
                        }
                        case 5: {
                            factory = null;
                            break;
                        }
                        case 7: {
                            broad.removeServiceStateListener(this);
                            factory = null;
                            break;
                        }
                    }
                    NimbusLogFactory.this.setCommonsLogFactory(factory);
                }

                public boolean isEnabledState(int state) {
                    return state == 3 || state == 5 || state == 7;
                }
            });
        }
        if (service.getState() == 3) {
            CommonsLogFactory factory = null;
            try {
                factory = (CommonsLogFactory)ServiceManagerFactory.getServiceObject(service.getServiceManagerName(), service.getServiceName());
            }
            catch (ServiceNotFoundException ex) {
                // empty catch block
            }
            this.setCommonsLogFactory(factory);
        }
    }

    private LogFactory createDefaultLogFactory() throws LogConfigurationException {
        ClassLoader classLoader;
        String factoryClass;
        LogFactory factory = null;
        try {
            factoryClass = System.getProperty(DEFAULT_FACTORY_PROPERTY);
            if (factoryClass != null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                factory = NimbusLogFactory.newFactory((String)factoryClass, (ClassLoader)classLoader);
            }
        }
        catch (SecurityException e) {
            factory = null;
        }
        if (factory == null && (factoryClass = (String)this.getAttribute(DEFAULT_FACTORY_PROPERTY)) != null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            factory = NimbusLogFactory.newFactory((String)factoryClass, (ClassLoader)classLoader);
        }
        if (factory == null) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            factory = NimbusLogFactory.newFactory((String)DEFAULT_FACTORY_DEFAULT, (ClassLoader)classLoader2);
        }
        if (factory != null) {
            String[] names = this.getAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                factory.setAttribute(name, this.getAttribute(name));
            }
        }
        return factory;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance((Object)clazz);
    }

    public Log getInstance(String name) throws LogConfigurationException {
        return this.getInstance((Object)name);
    }

    public void release() {
        this.logInstances.clear();
        if (this.logFactory != null) {
            this.logFactory.release();
        }
    }

    public Object getAttribute(String name) {
        if (this.logFactory != null) {
            return this.logFactory.getAttribute(name);
        }
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        if (this.logFactory != null) {
            return this.logFactory.getAttributeNames();
        }
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        if (this.logFactory != null) {
            this.logFactory.removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        if (this.logFactory != null) {
            this.logFactory.setAttribute(name, value);
        }
    }

    private class LogWrapper
    implements Log {
        private Log logger;
        private Log dummyLogger;
        private Log currentLogger;

        public LogWrapper(Log dummyLogger) {
            this(null, dummyLogger);
        }

        public LogWrapper(Log logger, Log dummyLogger) {
            this.logger = logger;
            this.dummyLogger = dummyLogger;
            this.currentLogger = logger != null ? logger : dummyLogger;
        }

        public void setRealLog(Log logger) {
            this.logger = logger;
        }

        public void real() {
            this.currentLogger = this.logger;
        }

        public void dummy() {
            this.currentLogger = this.dummyLogger;
        }

        public void trace(Object message) {
            this.currentLogger.trace(message);
        }

        public void trace(Object message, Throwable t) {
            this.currentLogger.trace(message, t);
        }

        public void debug(Object message) {
            this.currentLogger.debug(message);
        }

        public void debug(Object message, Throwable t) {
            this.currentLogger.debug(message, t);
        }

        public void info(Object message) {
            this.currentLogger.info(message);
        }

        public void info(Object message, Throwable t) {
            this.currentLogger.info(message, t);
        }

        public void warn(Object message) {
            this.currentLogger.warn(message);
        }

        public void warn(Object message, Throwable t) {
            this.currentLogger.warn(message, t);
        }

        public void error(Object message) {
            this.currentLogger.error(message);
        }

        public void error(Object message, Throwable t) {
            this.currentLogger.error(message, t);
        }

        public void fatal(Object message) {
            this.currentLogger.fatal(message);
        }

        public void fatal(Object message, Throwable t) {
            this.currentLogger.fatal(message, t);
        }

        public boolean isTraceEnabled() {
            return this.currentLogger.isTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return this.currentLogger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.currentLogger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.currentLogger.isWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return this.currentLogger.isErrorEnabled();
        }

        public boolean isFatalEnabled() {
            return this.currentLogger.isFatalEnabled();
        }
    }
}

