/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editorfinder;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.journal.editorfinder.ObjectMappedEditorFinderServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ObjectMappedEditorFinderService
extends ServiceBase
implements EditorFinder,
ObjectMappedEditorFinderServiceMBean,
Serializable {
    private static final String CLASS_NAME_BYTE = "byte";
    private static final String CLASS_NAME_BYTE_ARRAY = "byte[]";
    private static final String CLASS_NAME_CHAR = "char";
    private static final String CLASS_NAME_CHAR_ARRAY = "char[]";
    private static final String CLASS_NAME_SHORT = "short";
    private static final String CLASS_NAME_SHORT_ARRAY = "short[]";
    private static final String CLASS_NAME_INT = "int";
    private static final String CLASS_NAME_INT_ARRAY = "int[]";
    private static final String CLASS_NAME_LONG = "long";
    private static final String CLASS_NAME_LONG_ARRAY = "long[]";
    private static final String CLASS_NAME_FLOAT = "float";
    private static final String CLASS_NAME_FLOAT_ARRAY = "float[]";
    private static final String CLASS_NAME_DOUBLE = "double";
    private static final String CLASS_NAME_DOUBLE_ARRAY = "double[]";
    private EditorFinder mParentFinder = null;
    private ServiceName mFinderServiceName = null;
    private Properties mProp;
    private ClassMappingTree mEditorRepository = new ClassMappingTree();
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;

    /*
     * WARNING - void declaration
     */
    public void startService() throws Exception {
        if (this.mFinderServiceName != null) {
            this.mParentFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.mFinderServiceName);
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        Enumeration<Object> enumeration = this.mProp.keys();
        while (enumeration.hasMoreElements()) {
            void var6_6;
            Class<?> cls;
            String clsName = (String)enumeration.nextElement();
            String serviceName = this.mProp.getProperty(clsName);
            editor.setAsText(serviceName);
            ServiceName name = (ServiceName)editor.getValue();
            if (clsName.equals(CLASS_NAME_BYTE)) {
                cls = Byte.TYPE;
            } else if (clsName.equals(CLASS_NAME_BYTE_ARRAY)) {
                cls = array$B == null ? ObjectMappedEditorFinderService.class$("[B") : array$B;
            } else if (clsName.equals(CLASS_NAME_CHAR)) {
                cls = Character.TYPE;
            } else if (clsName.equals(CLASS_NAME_CHAR_ARRAY)) {
                cls = array$C == null ? ObjectMappedEditorFinderService.class$("[C") : array$C;
            } else if (clsName.equals(CLASS_NAME_SHORT)) {
                cls = Short.TYPE;
            } else if (clsName.equals(CLASS_NAME_SHORT_ARRAY)) {
                cls = array$S == null ? ObjectMappedEditorFinderService.class$("[S") : array$S;
            } else if (clsName.equals(CLASS_NAME_INT)) {
                cls = Integer.TYPE;
            } else if (clsName.equals(CLASS_NAME_INT_ARRAY)) {
                cls = array$I == null ? ObjectMappedEditorFinderService.class$("[I") : array$I;
            } else if (clsName.equals(CLASS_NAME_LONG)) {
                cls = Long.TYPE;
            } else if (clsName.equals(CLASS_NAME_LONG_ARRAY)) {
                cls = array$J == null ? ObjectMappedEditorFinderService.class$("[J") : array$J;
            } else if (clsName.equals(CLASS_NAME_FLOAT)) {
                cls = Float.TYPE;
            } else if (clsName.equals(CLASS_NAME_FLOAT_ARRAY)) {
                cls = array$F == null ? ObjectMappedEditorFinderService.class$("[F") : array$F;
            } else if (clsName.equals(CLASS_NAME_DOUBLE)) {
                cls = Double.TYPE;
            } else if (clsName.equals(CLASS_NAME_DOUBLE_ARRAY)) {
                cls = array$D == null ? ObjectMappedEditorFinderService.class$("[D") : array$D;
            } else {
                try {
                    cls = Class.forName(clsName, true, NimbusClassLoader.getInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceException("EditorFinderErr001", "ClassNotFoundException class name is " + clsName, e);
                }
            }
            JournalEditor jeditor = (JournalEditor)ServiceManagerFactory.getServiceObject(name);
            this.mEditorRepository.add((Class)var6_6, jeditor);
        }
    }

    public void stopService() throws Exception {
        this.mEditorRepository.clear();
    }

    public void destroyService() throws Exception {
        this.mParentFinder = null;
        this.mFinderServiceName = null;
        this.mParentFinder = null;
        this.mEditorRepository = null;
    }

    public JournalEditor findEditor(Class paramClass) {
        JournalEditor ret = (JournalEditor)this.mEditorRepository.getValue(paramClass);
        if (ret == null && this.mParentFinder != null) {
            ret = this.mParentFinder.findEditor(paramClass);
        }
        return ret;
    }

    public JournalEditor findEditor(Object paramObj) {
        Class<?> cls = paramObj != null ? paramObj.getClass() : null;
        return this.findEditor(cls);
    }

    public void setEditorProperties(Properties prop) {
        this.mProp = prop;
    }

    public void setParentEditorfinderServiceName(ServiceName name) {
        this.mFinderServiceName = name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

