/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeRemote;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.CodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.jmstopic.TopicTransanctionResource;
import jp.ossc.nimbus.service.sequence.Sequence;

public class CodeMasterService
extends ServiceBase
implements CodeMasterServiceMBean,
CodeMasterFinder,
MessageListener {
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private static final String MASTER_NAME_KEY = "key";
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private ServiceName mResourceFactoryServiceName = null;
    private ResourceFactory mResourceFactory = null;
    private ServiceName mJndiFinderServiceName = null;
    private JndiFinder mJndiFinder = null;
    private ServiceName mEJBFactoryServiceName = null;
    private EJBFactory mEjbFactory = null;
    private String mTopicName = null;
    private TopicTransanctionResource mTransanctionResource = null;
    private String[] mMasterNames = null;
    protected HashMap mMaster = null;
    private ServiceName mLoggerServiceName = null;
    private Logger mLogger = null;
    private ServiceName mSequenceServiceName = null;
    private Sequence mSequence = null;
    private String mUserId = null;

    public void setLoggerServiceName(ServiceName name) {
        this.mLoggerServiceName = name;
    }

    public void setMasterNames(String[] names) {
        this.mMasterNames = names;
    }

    public ServiceName getResourceFactoryServiceName() {
        return this.mResourceFactoryServiceName;
    }

    public void setResourceFactoryServiceName(ServiceName name) {
        this.mResourceFactoryServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getEJBFactoryServiceName() {
        return this.mEJBFactoryServiceName;
    }

    public void setEJBFactoryServiceName(ServiceName name) {
        this.mEJBFactoryServiceName = name;
    }

    public String getTopicName() {
        return this.mTopicName;
    }

    public void setTopicName(String name) {
        this.mTopicName = name;
    }

    public void startService() {
        this.mEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mEJBFactoryServiceName);
        this.mResourceFactory = (ResourceFactory)((Object)ServiceManagerFactory.getService(this.mResourceFactoryServiceName));
        this.mJndiFinder = (JndiFinder)((Object)ServiceManagerFactory.getService(this.mJndiFinderServiceName));
        if (this.mLoggerServiceName != null) {
            this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(this.mLoggerServiceName));
        }
        if (this.mLogger != null) {
            this.mLogger.write("MST_00001");
        }
        if (this.mSequenceServiceName != null) {
            this.mSequence = (Sequence)((Object)ServiceManagerFactory.getService(this.mSequenceServiceName));
        }
        try {
            this.initMasterHash();
        }
        catch (RemoteException e) {
            throw new ServiceException("CodeMaster011", "RemoteException", e);
        }
        catch (NamingException e) {
            throw new ServiceException("CodeMaster011", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("CodeMaster011", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("CodeMaster011", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("CodeMaster011", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("CodeMaster011", "InvocationTargetException", e);
        }
        try {
            this.entryTopicListener();
        }
        catch (Exception e1) {
            throw new ServiceException("CodeMaster021", "InvocationTargetException", e1);
        }
        if (this.mLogger != null) {
            this.mLogger.write("MST_00002");
        }
    }

    public void stopService() {
        try {
            this.mTransanctionResource.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        try {
            this.mTransanctionResource.getConnection().close();
        }
        catch (JMSException e1) {
            e1.printStackTrace();
        }
        this.mTransanctionResource = null;
    }

    public void destroyService() {
        this.mEjbFactory = null;
        this.mResourceFactory = null;
        this.mJndiFinder = null;
        this.mMaster = null;
        this.mLogger = null;
    }

    private void entryTopicListener() throws Exception {
        this.mTransanctionResource = (TopicTransanctionResource)this.mResourceFactory.makeResource("");
        Topic topic = null;
        topic = this.mTopicName == null ? (Topic)this.mJndiFinder.lookup("") : (Topic)this.mJndiFinder.lookup(this.mTopicName);
        TopicSubscriber subscriber = ((TopicSession)this.mTransanctionResource.getObject()).createSubscriber(topic);
        subscriber.setMessageListener((MessageListener)this);
        this.mTransanctionResource.getConnection().start();
    }

    private void initMasterHash() throws RemoteException, NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int status;
        if (this.mLogger != null) {
            this.mLogger.write("MST_00003");
        }
        this.mMaster = new HashMap();
        SLSBFacadeRemote remoteObj = (SLSBFacadeRemote)this.mEjbFactory.get("");
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        for (int cnt = 0; cnt < this.mMasterNames.length; ++cnt) {
            TimeManageMaster tmp = new TimeManageMaster();
            tmp.setMasterName(this.mMasterNames[cnt]);
            Command cmd = FacadeValueAccess.createCommand(this.mMasterNames[cnt], null);
            this.mMaster.put(this.mMasterNames[cnt], tmp);
            value.addCommand(cmd);
            if (this.mLogger == null) continue;
            this.mLogger.write("MST_00004", (Object)this.mMasterNames[cnt]);
        }
        FacadeValue ret = null;
        if (this.mUserId != null) {
            value.putHeader(C_USER_ID, this.mUserId);
        }
        if (this.mSequence != null) {
            value.putHeader(C_REQUEST_ID, this.mSequence.increment());
        }
        if (this.mLogger != null) {
            this.mLogger.write("MST_00005");
        }
        if ((status = (ret = remoteObj.invokeFacade(value)).getStatus()) == 0) {
            if (this.mLogger != null) {
                this.mLogger.write("MST_00006");
            }
            for (int cnt = 0; cnt < value.commandSize(); ++cnt) {
                Command tmp = (Command)value.getCommand(cnt);
                String key = tmp.getFlowKey();
                TimeManageMaster mst = (TimeManageMaster)this.mMaster.get(key);
                mst.addMaster(new Date(), tmp.getOutputObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCodeMasters() throws ServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = new Date();
        Set keys = this.mMaster.keySet();
        Iterator ite = keys.iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            TimeManageMaster tmp = null;
            HashMap hashMap = this.mMaster;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.mMaster.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block24: {
            SLSBFacadeRemote remoteObj = null;
            if (this.mLogger != null) {
                this.mLogger.write("MST_00007");
            }
            try {
                remoteObj = (SLSBFacadeRemote)this.mEjbFactory.get("");
            }
            catch (NamingException e) {
                throw new ServiceException("CodeMaster001", "NamingException", e);
            }
            catch (CreateException e) {
                throw new ServiceException("CodeMaster002", "CreateException", e);
            }
            catch (NoSuchMethodException e) {
                throw new ServiceException("CodeMaster003", "NoSuchMethodException", e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceException("CodeMaster004", "IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new ServiceException("CodeMaster005", "InvocationTargetException", e);
            }
            FacadeValue value = FacadeValueAccess.createCommandsValue();
            try {
                MapMessage mapMsg = (MapMessage)msg;
                Enumeration en = mapMsg.getMapNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Object tmp = this.mMaster.get(key);
                    if (this.mLogger != null) {
                        this.mLogger.write("MST_00008", (Object)key);
                    }
                    if (tmp == null) continue;
                    Object addMsg = mapMsg.getObject(key);
                    Command cmd = null;
                    cmd = FacadeValueAccess.createCommand(key, addMsg);
                    value.addCommand(cmd);
                }
                if (value.commandSize() <= 0) break block24;
                FacadeValue ret = null;
                if (this.mUserId != null) {
                    value.putHeader(C_USER_ID, this.mUserId);
                }
                if (this.mSequence != null) {
                    value.putHeader(C_REQUEST_ID, this.mSequence.increment());
                }
                if (this.mLogger != null) {
                    this.mLogger.write("MST_00009", value.commandSize());
                }
                ret = remoteObj.invokeFacade(value);
                for (int cnt = 0; cnt < ret.commandSize(); ++cnt) {
                    Command rec = (Command)ret.getCommand(cnt);
                    if (rec.getStatus() != 0) continue;
                    Object mst = rec.getOutputObject();
                    if (this.mLogger != null) {
                        this.mLogger.write("MST_00012", (Object)rec.getFlowKey());
                    }
                    TimeManageMaster tm = (TimeManageMaster)this.mMaster.get(rec.getFlowKey());
                    if (mst instanceof PartUpdate) {
                        PartUpdate pu = (PartUpdate)tm.getMaster(new Date());
                        PartUpdate indata = (PartUpdate)mst;
                        Iterator ite = indata.keySet().iterator();
                        while (ite.hasNext()) {
                            String key = (String)ite.next();
                            pu.put(key, indata.get(key));
                        }
                        tm.clear();
                    } else {
                        TimeManageMaster newTm = tm.cloneOwn();
                        long utc = mapMsg.getLong(rec.getFlowKey());
                        Date effectDt = new Date(utc);
                        newTm.addMaster(effectDt, mst);
                        newTm.clear();
                        HashMap hashMap = this.mMaster;
                        synchronized (hashMap) {
                            this.mMaster.put(rec.getFlowKey(), newTm);
                        }
                    }
                    if (this.mLogger == null) continue;
                    this.mLogger.write("MST_00013", (Object)rec.getFlowKey());
                }
            }
            catch (JMSException jmsex) {
                if (this.mLogger != null) {
                    this.mLogger.write("MST_00010", jmsex);
                }
            }
            catch (RemoteException e) {
                if (this.mLogger == null) break block24;
                this.mLogger.write("MST_00011", e);
            }
        }
    }

    public ServiceName getSequenceServiceName() {
        return this.mSequenceServiceName;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.mSequenceServiceName = name;
    }

    public void setUserId(String string) {
        this.mUserId = string;
    }

    private class TimeManageMaster {
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            rec.put(CodeMasterService.MASTER_DATA_KEY, master);
            rec.put(CodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                if (cnt == this.mTimeList.size() - 1) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(cnt + 1, rec);
                }
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                ret = map.get(CodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    this.mTimeList.remove(rcnt);
                }
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

