/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MockFactory;
import jp.ossc.nimbus.service.aop.interceptor.MockInterceptorServiceMBean;

public class MockInterceptorService
extends ServiceBase
implements Interceptor,
MockInterceptorServiceMBean {
    private String mockFactoryClassName;
    private ServiceName mockFactoryServiceName;
    private MockFactory mockFactory;

    public void setMockFactoryClassName(String className) {
        this.mockFactoryClassName = className;
    }

    public String getMockFactoryClassName() {
        return this.mockFactoryClassName;
    }

    public void setMockFactoryServiceName(ServiceName name) {
        this.mockFactoryServiceName = name;
    }

    public ServiceName getMockFactoryServiceName() {
        return this.mockFactoryServiceName;
    }

    public void startService() throws Exception {
        if (this.mockFactoryClassName != null && this.mockFactoryServiceName != null) {
            throw new IllegalArgumentException("Only either mockFactoryClassName or mockFactoryServiceName can be set.");
        }
        if (this.mockFactoryClassName != null) {
            this.mockFactory = (MockFactory)Class.forName(this.mockFactoryClassName, true, NimbusClassLoader.getInstance()).newInstance();
        } else if (this.mockFactoryServiceName != null) {
            this.mockFactory = (MockFactory)ServiceManagerFactory.getServiceObject(this.mockFactoryServiceName);
        } else {
            throw new IllegalArgumentException("It is necessary to set either mockFactoryClassName or mockFactoryServiceName.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object target = context.getTargetObject();
        try {
            if (this.getState() == 3) {
                context.setTargetObject(this.mockFactory.createMock(context));
            }
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            if (this.getState() == 3) {
                context.setTargetObject(target);
            }
        }
    }
}

