/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodMetricsInterceptorServiceMBean;

public class MethodMetricsInterceptorService
extends ServiceBase
implements Interceptor,
MethodMetricsInterceptorServiceMBean {
    private static final Comparator COMP = new MetricsInfoComparator();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Map metricsInfos;
    private boolean isEnabled = true;

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String displayMetricsInfo() {
        MetricsInfo[] infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
        Arrays.sort(infos, COMP);
        StringBuffer buf = new StringBuffer();
        buf.append("\"No.\",");
        buf.append("\"Method\",");
        buf.append("\"Count\",");
        buf.append("\"Best performance[ms]\",");
        buf.append("\"Worst performance[ms]\",");
        buf.append("\"Average performance[ms]\",");
        buf.append(LINE_SEP);
        for (int i = 0; i < infos.length; ++i) {
            buf.append('\"').append(i + 1).append('\"').append(',');
            buf.append('\"').append(infos[i].key).append('\"').append(',');
            buf.append('\"').append(infos[i].count).append('\"').append(',');
            buf.append('\"').append(infos[i].bestProcessTime).append('\"').append(',');
            buf.append('\"').append(infos[i].worstProcessTime).append('\"').append(',');
            buf.append('\"').append(infos[i].averageProcessTime).append('\"').append(LINE_SEP);
        }
        return buf.toString();
    }

    public void reset() {
        this.metricsInfos.clear();
    }

    public void createService() throws Exception {
        this.metricsInfos = new HashMap();
    }

    public void startService() throws Exception {
    }

    public void stopService() throws Exception {
        System.out.println(this.displayMetricsInfo());
        this.metricsInfos.clear();
    }

    public void destroyService() throws Exception {
        this.metricsInfos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object object;
        long start = System.currentTimeMillis();
        try {
            object = chain.invokeNext(context);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            block11: {
                Object var7_6 = null;
                long end = System.currentTimeMillis();
                if (this.getState() != 3 || !this.isEnabled()) break block11;
                MetricsInfo metricsInfo = null;
                Map map = this.metricsInfos;
                synchronized (map) {
                    MethodInvocationContext ctx = (MethodInvocationContext)context;
                    Class<?> target = ctx.getTargetObject();
                    Method method = ctx.getTargetMethod();
                    target = target == null ? method.getDeclaringClass() : target.getClass();
                    String key = ((Object)target).toString() + '>' + method;
                    metricsInfo = (MetricsInfo)this.metricsInfos.get(key);
                    if (metricsInfo == null) {
                        metricsInfo = new MetricsInfo(key);
                        this.metricsInfos.put(key, metricsInfo);
                    }
                }
                metricsInfo.calculate(end - start);
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        if (this.getState() == 3 && this.isEnabled()) {
            MetricsInfo metricsInfo = null;
            Map map = this.metricsInfos;
            synchronized (map) {
                MethodInvocationContext ctx = (MethodInvocationContext)context;
                Class<?> target = ctx.getTargetObject();
                Method method = ctx.getTargetMethod();
                target = target == null ? method.getDeclaringClass() : target.getClass();
                String key = ((Object)target).toString() + '>' + method;
                metricsInfo = (MetricsInfo)this.metricsInfos.get(key);
                if (metricsInfo == null) {
                    metricsInfo = new MetricsInfo(key);
                    this.metricsInfos.put(key, metricsInfo);
                }
            }
            metricsInfo.calculate(end - start);
        }
        return object;
    }

    private static class MetricsInfoComparator
    implements Comparator {
        private MetricsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            MetricsInfo info1 = (MetricsInfo)o1;
            MetricsInfo info2 = (MetricsInfo)o2;
            long sortKey1 = info1.averageProcessTime * (long)info1.count;
            long sortKey2 = info2.averageProcessTime * (long)info2.count;
            if (sortKey1 > sortKey2) {
                return -1;
            }
            if (sortKey1 < sortKey2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MetricsInfo
    implements Serializable {
        public String key;
        public int count;
        public long worstProcessTime = Long.MIN_VALUE;
        public long bestProcessTime = Long.MAX_VALUE;
        public long averageProcessTime;

        public MetricsInfo(String key) {
            this.key = key;
        }

        public synchronized void calculate(long time) {
            this.worstProcessTime = Math.max(this.worstProcessTime, time);
            this.bestProcessTime = Math.min(this.bestProcessTime, time);
            this.averageProcessTime = (this.averageProcessTime * (long)this.count + time) / (long)(this.count + 1);
            ++this.count;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('{');
            buf.append("count=").append(this.count);
            buf.append("worstProcessTime=").append(this.count == 0 ? 0L : this.worstProcessTime).append("[ms]");
            buf.append("bestProcessTime=").append(this.count == 0 ? 0L : this.bestProcessTime).append("[ms]");
            buf.append("averageProcessTime=").append(this.averageProcessTime).append("[ms]");
            buf.append('}');
            return buf.toString();
        }
    }
}

