/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.service.aop.DefaultInvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;

public class DefaultMethodInvocationContext
extends DefaultInvocationContext
implements MethodInvocationContext,
Serializable {
    protected transient Method targetMethod;
    protected Object[] parameters;

    public DefaultMethodInvocationContext(Object target, Method method, Object[] params) {
        super(target);
        this.targetMethod = method;
        this.parameters = params;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(Method method) {
        this.targetMethod = method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(new SerializableMethod(this.targetMethod));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.targetMethod = ((SerializableMethod)in.readObject()).getMethod();
    }

    protected static class SerializableMethod
    implements Serializable {
        private String declaringClassName;
        private String methodName;
        private List paramTypes;

        public SerializableMethod(Method method) {
            if (method != null) {
                this.declaringClassName = method.getDeclaringClass().getName();
                this.methodName = method.getName();
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes != null && paramTypes.length != 0) {
                    this.paramTypes = new ArrayList();
                    for (int i = 0; i < paramTypes.length; ++i) {
                        this.paramTypes.add(paramTypes[i].getName());
                    }
                }
            }
        }

        public Method getMethod() {
            if (this.declaringClassName == null || this.methodName == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(this.declaringClassName, true, Thread.currentThread().getContextClassLoader());
                if (this.paramTypes == null) {
                    return clazz.getDeclaredMethod(this.methodName, new Class[0]);
                }
                ArrayList<Class<Byte>> list = new ArrayList<Class<Byte>>();
                int max = this.paramTypes.size();
                for (int i = 0; i < max; ++i) {
                    String paramType = (String)this.paramTypes.get(i);
                    Class<Constable> paramClass = null;
                    paramClass = paramType.equals(Byte.TYPE.getName()) ? Byte.TYPE : (paramType.equals(Character.TYPE.getName()) ? Character.TYPE : (paramType.equals(Short.TYPE.getName()) ? Short.TYPE : (paramType.equals(Integer.TYPE.getName()) ? Integer.TYPE : (paramType.equals(Long.TYPE.getName()) ? Long.TYPE : (paramType.equals(Float.TYPE.getName()) ? Float.TYPE : (paramType.equals(Double.TYPE.getName()) ? Double.TYPE : (paramType.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : Class.forName(paramType, true, Thread.currentThread().getContextClassLoader()))))))));
                    list.add(paramClass);
                }
                return clazz.getDeclaredMethod(this.methodName, list.toArray(new Class[list.size()]));
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }
    }
}

