/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.AbstractInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.InvocationContext;

public abstract class AbstractThreadLocalInterceptorChain
extends AbstractInterceptorChain
implements Serializable {
    protected transient ThreadLocal state = new InheritableThreadLocal();

    public AbstractThreadLocalInterceptorChain(InterceptorChainList list) {
        super(list);
    }

    public AbstractThreadLocalInterceptorChain(ServiceName listServiceName) {
        super(listServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext(InvocationContext context) throws Throwable {
        InterceptorChainList list = this.interceptorChainList;
        if (this.interceptorChainListServiceName != null) {
            try {
                list = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
        }
        if (list == null) {
            return this.invokeTarget(context);
        }
        InterceptorChainState chainState = (InterceptorChainState)this.state.get();
        if (chainState == null) {
            chainState = new InterceptorChainState();
            this.state.set(chainState);
        }
        try {
            ++chainState.currentIndex;
            Interceptor interceptor = list.getInterceptor(chainState.currentIndex);
            if (interceptor != null) {
                Object object = interceptor.invoke(context, this);
                return object;
            }
            Object object = this.invokeTarget(context);
            return object;
        }
        finally {
            --chainState.currentIndex;
        }
    }

    public int getCurrentInterceptorIndex() {
        InterceptorChainState chainState = (InterceptorChainState)this.state.get();
        if (chainState == null) {
            return -1;
        }
        return chainState.currentIndex;
    }

    public void setCurrentInterceptorIndex(int index) {
        InterceptorChainState chainState = (InterceptorChainState)this.state.get();
        if (chainState == null) {
            chainState = new InterceptorChainState();
            this.state.set(chainState);
        }
        chainState.currentIndex = index;
    }

    protected static class InterceptorChainState
    implements Serializable {
        public int currentIndex = -1;

        protected InterceptorChainState() {
        }
    }
}

