/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.InvocationContext;

public abstract class AbstractInterceptorChain
implements InterceptorChain,
Serializable {
    protected int currentIndex = -1;
    protected transient InterceptorChainList interceptorChainList;
    protected ServiceName interceptorChainListServiceName;

    public AbstractInterceptorChain(InterceptorChainList list) {
        this.interceptorChainList = list;
    }

    public AbstractInterceptorChain(ServiceName listServiceName) {
        this.interceptorChainListServiceName = listServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext(InvocationContext context) throws Throwable {
        InterceptorChainList list = this.interceptorChainList;
        if (this.interceptorChainListServiceName != null) {
            try {
                list = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
        }
        if (list == null) {
            return this.invokeTarget(context);
        }
        try {
            ++this.currentIndex;
            Interceptor interceptor = list.getInterceptor(this.currentIndex);
            if (interceptor != null) {
                Object object = interceptor.invoke(context, this);
                return object;
            }
            Object object = this.invokeTarget(context);
            return object;
        }
        finally {
            --this.currentIndex;
        }
    }

    public int getCurrentInterceptorIndex() {
        return this.currentIndex;
    }

    public void setCurrentInterceptorIndex(int index) {
        this.currentIndex = index;
    }

    public InterceptorChainList getInterceptorChainList() {
        return this.interceptorChainList;
    }

    protected abstract Object invokeTarget(InvocationContext var1) throws Throwable;
}

