/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidDataException;
import jp.ossc.nimbus.recset.InvalidSchemaException;
import jp.ossc.nimbus.recset.RowSchema;

public class RowData
implements Serializable {
    public static final char C_KEY_SEPARATOR = '\u001c';
    public static final int E_Record_TypeRead = 0;
    public static final int E_Record_TypeUpdate = 1;
    public static final int E_Record_TypeDelete = 2;
    public static final int E_Record_TypeInsert = 3;
    public static final int E_Record_TypeIgnore = -1;
    private int mTransactionMode = -1;
    private RowSchema mRowSchema;
    private Object[] mFields;
    private int mRowIndex = -1;
    private String mKey = null;
    private String mDateFormat = null;

    public RowData(RowSchema rs) {
        this.mRowSchema = rs;
        this.mFields = new Object[rs.size()];
        this.mDateFormat = "yyyy.MM.dd";
    }

    protected RowData makeGoneData(RowSchema rs) {
        RowData rd = new RowData(rs);
        ArrayList<Object> lst = new ArrayList<Object>();
        for (int rcnt = 0; rcnt < this.getRowSchema().size(); ++rcnt) {
            FieldSchema fs = this.getRowSchema().get(rcnt);
            if (!fs.isUpdateField()) continue;
            lst.add(this.get(rcnt));
        }
        rd.mFields = lst.toArray();
        rd.mTransactionMode = this.getTransactionMode();
        rd.makeUniqueKey();
        return rd;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getRowIndex() {
        return this.mRowIndex;
    }

    public RowSchema getRowSchema() {
        return this.mRowSchema;
    }

    public int getTransactionMode() {
        return this.mTransactionMode;
    }

    protected void setRowIndex(int i) {
        this.mRowIndex = i;
    }

    public void setTransactionModeForce(int trMode) {
        this.mTransactionMode = trMode;
    }

    public void setTransactionMode(int trMode) {
        boolean wrtFlg = false;
        switch (this.getTransactionMode()) {
            case 0: {
                if (trMode != 1 && trMode != 2) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 1: {
                if (trMode != 2 && trMode != 0) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 2: {
                if (trMode == 3) {
                    this.mTransactionMode = 1;
                    break;
                }
                if (trMode != 1 && trMode != 0) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 3: {
                if (trMode == 2) {
                    this.mTransactionMode = -1;
                }
                wrtFlg = true;
                break;
            }
            default: {
                if (trMode == 3) {
                    this.mTransactionMode = trMode;
                    wrtFlg = true;
                    break;
                }
                if (trMode == 1) {
                    this.mTransactionMode = 3;
                    wrtFlg = true;
                    break;
                }
                if (trMode != 0) break;
                this.mTransactionMode = trMode;
                wrtFlg = true;
            }
        }
        if (wrtFlg) {
            this.makeUniqueKey();
        }
    }

    public void makeUniqueKey() {
        StringBuffer ret = new StringBuffer();
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            if (!this.getRowSchema().get(rcnt).isUniqueKey()) continue;
            ret.append(this.getString(rcnt));
            ret.append('\u001c');
        }
        this.mKey = ret.toString();
        if (this.mKey.length() > 2) {
            this.mKey = this.mKey.substring(0, this.mKey.length() - 1);
        }
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.mFields).listIterator();
    }

    public Object get(int index) {
        return this.mFields[index];
    }

    public Object get(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.mFields[scm.getIndex()];
    }

    public String getString(int index) {
        int type = this.mRowSchema.get(index).getFieldType();
        Object obj = this.mFields[index];
        if (obj != null) {
            String ret = null;
            switch (type) {
                case 3: {
                    ret = (String)obj;
                    break;
                }
                case 2: {
                    ret = (String)obj;
                    break;
                }
                case 4: {
                    SimpleDateFormat sf = new SimpleDateFormat(this.mDateFormat);
                    ret = sf.format((Date)obj);
                    break;
                }
                case 1: 
                case 5: 
                case 7: 
                case 8: {
                    ret = obj.toString();
                    break;
                }
            }
            return ret;
        }
        return null;
    }

    public String getStringValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        return (String)this.mFields[index];
    }

    public Date getDateValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 4: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        return (Date)this.mFields[index];
    }

    public Integer getIntegerValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            return null;
        }
        return new Integer(tmp.intValue());
    }

    public int getIntValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        return tmp.intValue();
    }

    public Long getLongValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            return null;
        }
        return new Long(tmp.longValue());
    }

    public long getPrimitiveLongValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        return tmp.longValue();
    }

    public Float getFloatValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            return null;
        }
        return new Float(tmp.floatValue());
    }

    public float getPrimitiveFloatValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        return tmp.floatValue();
    }

    public Double getDoubleValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            return null;
        }
        return new Double(tmp.doubleValue());
    }

    public double getPrimitiveDoubleValue(int index) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        Number tmp = (Number)this.mFields[index];
        return tmp.doubleValue();
    }

    public String getString(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getString(scm.getIndex());
    }

    public String getStringValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getStringValue(scm.getIndex());
    }

    public Date getDateValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getDateValue(scm.getIndex());
    }

    public Integer getIntegerValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getIntegerValue(scm.getIndex());
    }

    public int getIntValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getIntValue(scm.getIndex());
    }

    public Long getLongValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getLongValue(scm.getIndex());
    }

    public long getPrimitiveLongValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getPrimitiveLongValue(scm.getIndex());
    }

    public Float getFloatValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getFloatValue(scm.getIndex());
    }

    public float getPrimitiveFloatValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getPrimitiveFloatValue(scm.getIndex());
    }

    public Double getDoubleValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getDoubleValue(scm.getIndex());
    }

    public double getPrimitiveDoubleValue(String key) {
        FieldSchema scm = this.mRowSchema.get(key);
        return this.getPrimitiveDoubleValue(scm.getIndex());
    }

    protected void setValueNative(int index, Object value) {
        FieldSchema fs = this.mRowSchema.get(index);
        if (fs.isUniqueKey()) {
            switch (this.getTransactionMode()) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.mFields[index] == null) break;
                    return;
                }
            }
        }
        this.mFields[index] = value;
        if (fs.isUniqueKey()) {
            this.makeUniqueKey();
        }
    }

    public void setValue(int index, String value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, Date value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 4: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, Integer value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        if (value != null && this.mRowSchema.get(index).getFieldLength() > 0 && value != 0) {
            String tmp = value.toString();
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidDataException("length over");
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, int value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != 0) {
            String tmp = Integer.toString(value);
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidDataException("length over");
            }
        }
        this.setValueNative(index, new Integer(value));
    }

    public void setValue(int index, Long value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        if (value != null && this.mRowSchema.get(index).getFieldLength() > 0 && value != 0L) {
            String tmp = value.toString();
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidDataException("length over");
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, long value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != 0L) {
            String tmp = Long.toString(value);
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidDataException("length over");
            }
        }
        this.setValueNative(index, new Long(value));
    }

    public void setValue(int index, Float value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.mFields[index] = value;
    }

    public void setValue(int index, float value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.mFields[index] = new Float(value);
    }

    public void setValue(int index, Double value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.mFields[index] = value;
    }

    public void setValue(int index, double value) {
        switch (this.mRowSchema.get(index).getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException();
            }
        }
        this.mFields[index] = new Double(value);
    }

    public void setValue(String key, String value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, Date value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, Integer value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, int value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, Long value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, long value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, Float value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, float value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, Double value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public void setValue(String key, double value) {
        FieldSchema scm = this.mRowSchema.get(key);
        this.setValue(scm.getIndex(), value);
    }

    public int size() {
        return this.mFields.length;
    }

    public RowData cloneRowData() {
        RowData rd = new RowData(this.getRowSchema());
        for (int rcnt = 0; rcnt < this.mFields.length; ++rcnt) {
            rd.mFields[rcnt] = this.cloneFieldData(rcnt);
        }
        return rd;
    }

    private Object cloneFieldData(int index) {
        Object ret = null;
        FieldSchema schema = this.mRowSchema.get(index);
        Object value = this.mFields[index];
        switch (schema.getFieldType()) {
            case 2: 
            case 3: {
                if (value == null) break;
                ret = new String((String)value);
                break;
            }
            case 4: {
                if (value == null) break;
                Date dt = (Date)value;
                ret = new Date(dt.getTime());
                break;
            }
            case 8: {
                if (value == null) break;
                Long tmp = (Long)value;
                ret = new Long(tmp);
                break;
            }
            case 1: {
                if (value == null) break;
                Integer tmp = (Integer)value;
                ret = new Integer(tmp);
                break;
            }
            case 5: {
                if (value == null) break;
                Float tmp = (Float)value;
                ret = new Float(tmp.floatValue());
                break;
            }
            case 7: {
                if (value == null) break;
                Double tmp = (Double)value;
                ret = new Double(tmp);
                break;
            }
        }
        return ret;
    }

    private List getFields() {
        return Arrays.asList(this.mFields);
    }

    public boolean equals(RowData rd) {
        boolean ret = true;
        if (this.getRowSchema() == rd.getRowSchema()) {
            for (int rcnt = 0; rcnt < this.getFields().size(); ++rcnt) {
                Object obj0 = this.get(rcnt);
                Object obj1 = rd.get(rcnt);
                if (obj0 == null && obj1 == null) continue;
                if (obj0 == null || obj1 == null) {
                    ret = false;
                } else {
                    if (obj0.equals(obj1)) continue;
                    ret = false;
                }
                break;
            }
        } else {
            ret = false;
        }
        return ret;
    }
}

