/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidDataException;
import jp.ossc.nimbus.recset.RowData;
import jp.ossc.nimbus.recset.RowSchema;
import jp.ossc.nimbus.recset.RowVersionException;
import jp.ossc.nimbus.recset.SchemaManager;
import jp.ossc.nimbus.service.log.Logger;

public class RecordSet
implements Serializable {
    public static final String C_SEPARATOR = System.getProperty("line.separator");
    private static final String C_SET_TOKEN = " SET ";
    private static final String C_UPDATE_TOKEN = "UPDATE ";
    private static final String C_QUESTION_TOKEN = "?";
    private static final String C_EQUAL_TOKEN = "=";
    private static final String C_SEMICOLON_TOKEN = ";";
    private static final String C_AND_TOKEN = " AND ";
    private static final String C_WHERE_TOKEN = " WHERE ";
    private static final String C_VALUES_TOKEN = " VALUES ";
    private static final String C_BRACKETS_END_TOKEN = " ) ";
    private static final String C_BRACKETS_BEGIN_TOKEN = " ( ";
    private static final String C_DELETE_TOKEN = "DELETE FROM ";
    private static final String C_INSERT_TOKEN = "INSERT INTO ";
    private static final String C_ORDER_TOKEN = " ORDER BY ";
    private static final String C_FROM_TOKEN = " FROM ";
    private static final String C_COMMA_TOKEN = ",";
    private static final String C_SELECT_TOKEN = "SELECT ";
    private static final String C_DISTINCT_TOKEN = " DISTINCT ";
    private RowSchema mSchema;
    private ArrayList mRows = new ArrayList();
    private HashMap mHash = new HashMap();
    private String mTableNames;
    private String mOrder;
    private transient Connection mCon;
    private Logger mLogger = null;
    private String mMessageCode = null;
    private boolean mDistinctFlg = false;

    public RowSchema getRowSchema() {
        return this.mSchema;
    }

    public void setLogger(Logger lg) {
        this.mLogger = lg;
    }

    public void setMessageCode(String code) {
        this.mMessageCode = code;
    }

    protected ArrayList getList() {
        return this.mRows;
    }

    protected HashMap getHash() {
        return this.mHash;
    }

    public void initSchema(String schema) {
        this.mSchema = SchemaManager.findRowSchema(schema);
    }

    public void setFromTable(String tableStr) {
        this.mTableNames = tableStr;
    }

    public void setOrderbyStr(String order) {
        this.mOrder = order;
    }

    public void setConnection(Connection con) {
        this.mCon = con;
    }

    public Connection getConnection() {
        return this.mCon;
    }

    public void insertRecord(RowData rd) {
        rd.setTransactionMode(3);
        this.addRecord(rd);
    }

    protected void addRecord(RowData rd) {
        String key = rd.getKey();
        Object tmp = this.mHash.get(key);
        if (tmp != null) {
            throw new InvalidDataException("key duplicate");
        }
        this.mHash.put(key, rd);
        this.mRows.add(rd);
        rd.setRowIndex(this.mRows.size() - 1);
    }

    public void clear() {
        this.mRows.clear();
        this.mHash.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int search() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(C_SELECT_TOKEN);
        if (this.mDistinctFlg) {
            sb.append(C_DISTINCT_TOKEN);
        }
        for (int rcnt = 0; rcnt < this.mSchema.size(); ++rcnt) {
            sb.append(this.mSchema.get(rcnt).getFieldName());
            if (rcnt == this.mSchema.size() - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        sb.append(C_FROM_TOKEN).append(this.mTableNames).append(" ");
        this.addWhere(sb);
        if (this.mOrder != null) {
            sb.append(C_ORDER_TOKEN).append(this.mOrder);
        }
        Statement ps = null;
        try {
            String statement = sb.toString();
            ps = this.mCon.prepareStatement(statement);
            if (this.mLogger != null) {
                this.mLogger.write(this.mMessageCode, (Object)sb.toString());
            }
            this.addBindData((PreparedStatement)ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RowData rd = this.createNewRecord();
                for (int rcnt = 0; rcnt < this.mSchema.size(); ++rcnt) {
                    Object obj = rs.getObject(rcnt + 1);
                    rd.setValueNative(rcnt, obj);
                }
                rd.setTransactionMode(0);
                this.addRecord(rd);
            }
            int n = this.size();
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public RowData createNewRecord() {
        RowData rd = new RowData(this.mSchema);
        return rd;
    }

    protected void addBindData(PreparedStatement ps) throws SQLException {
    }

    protected void addWhere(StringBuffer sb) {
    }

    public RowData get(int index) {
        RowData rd = (RowData)this.mRows.get(index);
        return rd;
    }

    public RowData get(String key) {
        RowData rd = (RowData)this.mHash.get(key);
        return rd;
    }

    public int size() {
        return this.mRows.size();
    }

    public RecordSet makeGoneData() throws InstantiationException, IllegalAccessException {
        RecordSet ret = (RecordSet)this.getClass().newInstance();
        ret.mSchema = SchemaManager.findGoneRowSchema(this.mSchema);
        for (int rcnt = this.size() - 1; rcnt >= 0; --rcnt) {
            RowData rd = this.get(rcnt);
            int tmode = rd.getTransactionMode();
            if (tmode != 2 && tmode != 3 && tmode != 1) continue;
            ret.addRecord(rd.makeGoneData(ret.mSchema));
        }
        ret.mHash = null;
        ret.mTableNames = this.mTableNames;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord() throws SQLException, RowVersionException {
        PreparedStatement psUpdate;
        PreparedStatement psDelete;
        block18: {
            int updateCnt = 0;
            int insertCnt = 0;
            int deleteCnt = 0;
            block7: for (int cnt = 0; cnt < this.size(); ++cnt) {
                RowData rd = this.get(cnt);
                switch (rd.getTransactionMode()) {
                    case 3: {
                        ++insertCnt;
                        continue block7;
                    }
                    case 2: {
                        ++deleteCnt;
                        continue block7;
                    }
                    case 1: {
                        ++updateCnt;
                    }
                }
            }
            psDelete = null;
            PreparedStatement psInsert = null;
            psUpdate = null;
            try {
                int[] result;
                if (deleteCnt > 0 && (psDelete = this.createDeletePreparedStatement()) != null) {
                    result = psDelete.executeBatch();
                    if (psDelete.getUpdateCount() != deleteCnt) {
                        throw new RowVersionException();
                    }
                }
                if (insertCnt > 0 && (psInsert = this.createInsertPreparedStatement()) != null) {
                    result = psInsert.executeBatch();
                    psInsert.close();
                }
                if (updateCnt > 0 && (psUpdate = this.createUpdatePreparedStatement()) != null) {
                    result = psUpdate.executeBatch();
                    if (psUpdate.getUpdateCount() != updateCnt) {
                        throw new RowVersionException();
                    }
                }
                Object var9_9 = null;
                if (psInsert == null) break block18;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (psInsert != null) {
                    psInsert.close();
                }
                if (psUpdate != null) {
                    psUpdate.close();
                }
                if (psDelete != null) {
                    psDelete.close();
                }
                throw throwable;
            }
            psInsert.close();
        }
        if (psUpdate != null) {
            psUpdate.close();
        }
        if (psDelete != null) {
            psDelete.close();
        }
    }

    private PreparedStatement createInsertPreparedStatement() throws SQLException {
        int rcnt;
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        RowSchema rSchema = this.mSchema;
        sb.append(C_INSERT_TOKEN);
        sb.append(this.mTableNames);
        sb.append(C_BRACKETS_BEGIN_TOKEN);
        for (rcnt = 0; rcnt < rSchema.size(); ++rcnt) {
            sb.append(rSchema.get(rcnt).getFieldName());
            if (rcnt == rSchema.size() - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        this.addInsertColmun(sb);
        sb.append(C_BRACKETS_END_TOKEN);
        sb.append(C_VALUES_TOKEN);
        sb.append(C_BRACKETS_BEGIN_TOKEN);
        for (rcnt = 0; rcnt < rSchema.size(); ++rcnt) {
            sb.append(C_QUESTION_TOKEN);
            if (rcnt == rSchema.size() - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        this.addInsertField(sb);
        sb.append(C_BRACKETS_END_TOKEN);
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        for (rcnt = 0; rcnt < this.size(); ++rcnt) {
            RowData rd = this.get(rcnt);
            int param_idx = 1;
            if (rd.getTransactionMode() != 3) continue;
            for (int fidx = 0; fidx < rSchema.size(); ++fidx) {
                if (rSchema.get(fidx).isRowVersionField()) {
                    ps.setObject(param_idx++, new Integer(1));
                    continue;
                }
                Object o = rd.get(fidx);
                if (o == null) {
                    ps.setNull(param_idx++, 12, "java.lang.String");
                    continue;
                }
                ps.setObject(param_idx++, o);
            }
            this.addInsertBind(ps, param_idx);
            ps.addBatch();
        }
        return ps;
    }

    protected void addInsertColmun(StringBuffer sb) {
    }

    protected void addInsertField(StringBuffer sb) {
    }

    protected void addInsertBind(PreparedStatement ps, int idnex) throws SQLException {
    }

    private PreparedStatement createUpdatePreparedStatement() throws SQLException {
        int rcnt;
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        RowSchema rSchema = this.mSchema;
        sb.append(C_UPDATE_TOKEN);
        sb.append(this.mTableNames);
        sb.append(C_SET_TOKEN);
        for (int rcnt2 = 0; rcnt2 < rSchema.size(); ++rcnt2) {
            if (!rSchema.get(rcnt2).isUpdateField() || rSchema.get(rcnt2).isUniqueKey()) continue;
            sb.append(rSchema.get(rcnt2).getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            if (rcnt2 == rSchema.size() - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        this.addUpdateField(sb);
        boolean whereFlg = false;
        for (rcnt = 0; rcnt < rSchema.size(); ++rcnt) {
            FieldSchema fSchema = rSchema.get(rcnt);
            if (!fSchema.isUniqueKey() && !fSchema.isRowVersionField()) continue;
            if (!whereFlg) {
                sb.append(C_WHERE_TOKEN);
                whereFlg = true;
            }
            sb.append(fSchema.getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            sb.append(C_AND_TOKEN);
        }
        if (whereFlg) {
            sb.delete(sb.length() - 5, sb.length());
        }
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        for (rcnt = 0; rcnt < this.size(); ++rcnt) {
            int fidx;
            RowData rd = this.get(rcnt);
            int param_idx = 1;
            if (rd.getTransactionMode() != 1) continue;
            for (fidx = 0; fidx < rSchema.size(); ++fidx) {
                FieldSchema fSchema = rSchema.get(fidx);
                if (!fSchema.isUpdateField() || fSchema.isUniqueKey()) continue;
                if (fSchema.isRowVersionField()) {
                    ps.setObject(param_idx++, new Integer(rd.getIntValue(fidx) + 1));
                    continue;
                }
                Object o = rd.get(fidx);
                if (o == null) {
                    ps.setNull(param_idx++, 12, "java.lang.String");
                    continue;
                }
                ps.setObject(param_idx++, o);
            }
            param_idx = this.addUpdateBind(ps, param_idx);
            for (fidx = 0; fidx < rSchema.size(); ++fidx) {
                if (!rSchema.get(fidx).isUniqueKey() && !rSchema.get(fidx).isRowVersionField()) continue;
                Object o = rd.get(fidx);
                if (o == null) {
                    ps.setNull(param_idx++, 12, "java.lang.String");
                    continue;
                }
                ps.setObject(param_idx++, o);
            }
            ps.addBatch();
        }
        return ps;
    }

    protected void addUpdateField(StringBuffer sb) {
    }

    protected int addUpdateBind(PreparedStatement ps, int index) throws SQLException {
        return index;
    }

    private PreparedStatement createDeletePreparedStatement() throws SQLException {
        int rcnt;
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        RowSchema rSchema = this.mSchema;
        sb.append(C_DELETE_TOKEN);
        sb.append(this.mTableNames);
        boolean whereFlg = false;
        for (rcnt = 0; rcnt < rSchema.size(); ++rcnt) {
            if (!rSchema.get(rcnt).isUniqueKey()) continue;
            if (!whereFlg) {
                sb.append(C_WHERE_TOKEN);
                whereFlg = true;
            }
            sb.append(rSchema.get(rcnt).getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            sb.append(C_AND_TOKEN);
        }
        if (whereFlg) {
            sb.delete(sb.length() - 5, sb.length());
        }
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        for (rcnt = 0; rcnt < this.size(); ++rcnt) {
            RowData rd = this.get(rcnt);
            int param_idx = 1;
            if (rd.getTransactionMode() != 2) continue;
            for (int fidx = 0; fidx < rSchema.size(); ++fidx) {
                if (!rSchema.get(fidx).isUniqueKey()) continue;
                Object o = rd.get(fidx);
                if (o == null) {
                    ps.setNull(param_idx++, 12, "java.lang.String");
                    continue;
                }
                ps.setObject(param_idx++, rd.get(fidx));
            }
            ps.addBatch();
        }
        return ps;
    }

    protected void setDistinctFlg(boolean flg) {
        this.mDistinctFlg = flg;
    }
}

