/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.CommandBase;
import jp.ossc.nimbus.ioc.IOCException;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.ejb.UtilTool;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandHomeLocal;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandLocal;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkHomeLocal;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkLocal;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.log.Logger;

public class EJBDriveDispatcher {
    private SessionContext mContext = null;
    private SLSBUnitOfWorkLocal mUnitOfWorkInvokerLocal = null;
    private SLSBCommandLocal mCommandInvokerLocal = null;
    private InterceptorChainInvokerFactory mFactory = null;
    private String mInterceptorKey = null;
    private UnitOfWork mRetUow = null;
    private Logger mLogger = null;
    protected final String IOC__00001 = "IOC__00001";
    protected final String IOC__00002 = "IOC__00002";
    protected final String IOC__00003 = "IOC__00003";

    public void init(String unitOfWorkKey, String commandKey, String intercetorFactrySvcName, String interceptorCreateKey, String loggerServiceName) throws NamingException, CreateException {
        InitialContext ctx = new InitialContext();
        String value = (String)ctx.lookup(loggerServiceName);
        if (value == null || value.length() == 0) {
            this.mLogger = null;
        } else {
            ServiceName serviceName = UtilTool.convertServiceName(value);
            this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
        }
        value = (String)ctx.lookup(unitOfWorkKey);
        SLSBUnitOfWorkHomeLocal unitOfWorkInvokerHome = (SLSBUnitOfWorkHomeLocal)ctx.lookup(value);
        this.mUnitOfWorkInvokerLocal = unitOfWorkInvokerHome.create();
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00001", (Object)"SLSBUnitOfWorkHomeLocal get cmpleted.");
        }
        value = (String)ctx.lookup(commandKey);
        SLSBCommandHomeLocal commandInvokerHome = (SLSBCommandHomeLocal)ctx.lookup(value);
        this.mCommandInvokerLocal = commandInvokerHome.create();
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00001", (Object)"SLSBCommandHomeLocal get cmpleted.");
        }
        if ((value = (String)ctx.lookup(intercetorFactrySvcName)) == null || value.length() == 0) {
            this.mFactory = null;
        } else {
            ServiceName serviceName = UtilTool.convertServiceName(value);
            this.mFactory = (InterceptorChainInvokerFactory)((Object)ServiceManagerFactory.getService(serviceName));
            this.mInterceptorKey = value = (String)ctx.lookup(interceptorCreateKey);
        }
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00001", (Object)"InterceptorChainInvokerFactory get completed.");
        }
    }

    protected void setRetUnitOfWork(UnitOfWork retUow) {
        this.mRetUow = retUow;
    }

    protected Logger getLogger() {
        return this.mLogger;
    }

    public Object invokeInterceptor(Object input) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        Object ret = null;
        if (this.mFactory == null) {
            try {
                ret = this.invokeUnitOfWorkBase((UnitOfWork)input);
            }
            catch (IOCException e) {
                throw new TargetUncheckedException(e.getCause());
            }
            catch (Throwable e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00018", e);
                }
                throw new TargetUncheckedException(e);
            }
        } else {
            if (this.getLogger() != null) {
                this.getLogger().write("IOC__00004", (Object)this.getInterceptorKey());
            }
            InterceptorChainInvoker ici = this.mFactory.createInterceptorInvoker(this.getInterceptorKey());
            ret = ici.invokeChain(this, input);
        }
        return ret;
    }

    public UnitOfWork invokeUnitOfWorkBase(UnitOfWork uow) throws Exception {
        UnitOfWork retUow = this.mRetUow;
        boolean cmdErrFlg = false;
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00002");
        }
        for (int rcnt = 0; rcnt < uow.size(); ++rcnt) {
            CommandBase tmp = uow.getCommand(rcnt);
            try {
                CommandBase ret;
                if (tmp.isCommand()) {
                    if (!cmdErrFlg) {
                        ret = this.mCommandInvokerLocal.invokeCommand((Command)tmp);
                        if (ret.getStatus() == 1) {
                            if (this.getLogger() != null) {
                                this.getLogger().write("IOC__00020");
                            }
                            this.getContext().setRollbackOnly();
                            cmdErrFlg = true;
                        }
                        retUow.addCommand((Command)ret);
                        continue;
                    }
                    if (this.getLogger() != null) {
                        this.getLogger().write("IOC__00021");
                    }
                    retUow.addCommand((Command)tmp);
                    continue;
                }
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00015");
                }
                ret = this.mUnitOfWorkInvokerLocal.invokeUnitOfWork((UnitOfWork)tmp);
                retUow.addUnitOfWork((UnitOfWork)ret);
                continue;
            }
            catch (EJBException e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00017", e.getCausedByException());
                }
                Exception ex = e.getCausedByException();
                throw ex;
            }
            catch (Throwable e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00017", e);
                }
                IOCException ex = new IOCException("EJBDispatcher#invokeUnitOfWorkBase Unrecognized Error ", e);
                throw ex;
            }
        }
        return retUow;
    }

    public SessionContext getContext() {
        return this.mContext;
    }

    public InterceptorChainInvokerFactory getFactory() {
        return this.mFactory;
    }

    public String getInterceptorKey() {
        return this.mInterceptorKey;
    }

    public void setContext(SessionContext context) {
        this.mContext = context;
    }

    public void setInterceptorKey(String string) {
        this.mInterceptorKey = string;
    }
}

