/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FilenameFilter;

public class PrefixFileFilter
implements FilenameFilter {
    protected String mPrefixOfFileName = null;
    protected String mUpperPrefixOfFileName = null;
    protected boolean mIsIgnoreCase = false;

    public PrefixFileFilter(String prefixOfFileName) {
        this.mPrefixOfFileName = prefixOfFileName;
    }

    public PrefixFileFilter(String prefixOfFileName, boolean ignoreCase) {
        this.mPrefixOfFileName = prefixOfFileName;
        this.mIsIgnoreCase = ignoreCase;
        if (this.mIsIgnoreCase) {
            this.mUpperPrefixOfFileName = this.mPrefixOfFileName.toUpperCase();
        }
    }

    public boolean accept(File arg0, String fileName) {
        if (this.mIsIgnoreCase) {
            String tmp = fileName.toUpperCase();
            return tmp.startsWith(this.mUpperPrefixOfFileName);
        }
        return fileName.startsWith(this.mPrefixOfFileName);
    }

    public String getPrefixString() {
        return this.mPrefixOfFileName;
    }
}

