/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FilenameFilter;

public class ExtentionFileFilter
implements FilenameFilter {
    protected String mExtentionOfFileName = null;
    protected String mUpperExtentionOfFileName = null;
    protected boolean mIsIgnoreCase = false;
    protected static final String C_COMMA = ".";

    public ExtentionFileFilter() {
        this.mExtentionOfFileName = new String();
        this.mUpperExtentionOfFileName = new String();
    }

    public ExtentionFileFilter(String extentionOfFileName) {
        this.mExtentionOfFileName = extentionOfFileName.startsWith(C_COMMA) ? extentionOfFileName : C_COMMA + extentionOfFileName;
        this.mUpperExtentionOfFileName = this.mExtentionOfFileName.toUpperCase();
    }

    public ExtentionFileFilter(String extentionOfFileName, boolean isIgnoreCase) {
        this.mExtentionOfFileName = extentionOfFileName.startsWith(C_COMMA) ? extentionOfFileName : C_COMMA + extentionOfFileName;
        this.mUpperExtentionOfFileName = this.mExtentionOfFileName.toUpperCase();
        this.mIsIgnoreCase = isIgnoreCase;
    }

    public void setExtentionOfFileName(String extentionOfFileName) {
        this.mExtentionOfFileName = extentionOfFileName.startsWith(C_COMMA) ? extentionOfFileName : C_COMMA + extentionOfFileName;
        this.mUpperExtentionOfFileName = this.mExtentionOfFileName.toUpperCase();
    }

    public void setIgnoreCase(boolean isIgnoreCase) {
        this.mIsIgnoreCase = isIgnoreCase;
    }

    public boolean accept(File file, String fileName) {
        if (this.mIsIgnoreCase) {
            String tmp = fileName.toUpperCase();
            return tmp.endsWith(this.mUpperExtentionOfFileName);
        }
        return fileName.endsWith(this.mExtentionOfFileName);
    }

    public String getExtention() {
        return this.mExtentionOfFileName;
    }
}

