/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class ServiceNameMetaData
extends MetaData
implements Serializable {
    private static final String MANAGER_NAME_ATTRIBUTE_NAME = "manager-name";
    private String managerName;
    private String serviceName;

    public ServiceNameMetaData(MetaData parent) {
        super(parent);
    }

    public ServiceNameMetaData(MetaData parent, String manager) {
        super(parent);
        this.managerName = manager;
    }

    public ServiceNameMetaData(MetaData parent, String manager, String service) {
        super(parent);
        this.managerName = manager;
        this.serviceName = service;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String name) {
        this.managerName = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        this.managerName = ServiceNameMetaData.getOptionalAttribute(element, MANAGER_NAME_ATTRIBUTE_NAME, this.managerName == null ? "Nimbus" : this.managerName);
        String content = ServiceNameMetaData.getElementContent(element);
        if (content != null && content.length() != 0) {
            this.serviceName = content;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceNameMetaData) {
            ServiceNameMetaData name = (ServiceNameMetaData)obj;
            if (this.managerName == null && name.managerName != null || this.managerName != null && name.managerName == null) {
                return false;
            }
            if (this.managerName != null && name.managerName != null && !this.managerName.equals(name.managerName)) {
                return false;
            }
            if (this.serviceName == null && name.serviceName != null || this.serviceName != null && name.serviceName == null) {
                return false;
            }
            return this.serviceName == null || name.serviceName == null || this.serviceName.equals(name.serviceName);
        }
        return false;
    }

    public int hashCode() {
        return (this.managerName != null ? this.managerName.hashCode() : 0) + (this.serviceName != null ? this.serviceName.hashCode() : 0);
    }
}

