/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ServiceMetaData
extends MetaData
implements Serializable {
    public static final String SERVICE_TAG_NAME = "service";
    public static final String ATTRIBUTE_TAG_NAME = "attribute";
    private static final String DEPENDS_TAG_NAME = "depends";
    private static final String OPT_CONF_TAG_NAME = "optional-config";
    private static final String CODE_ATTRIBUTE_NAME = "code";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String MANAGER_NAME_ATTRIBUTE_NAME = "manager-name";
    private String code;
    private String name;
    private final Map attributes = new HashMap();
    private transient Element optionalConfig;
    private final List depends = new ArrayList();
    private ManagerMetaData manager;
    private ServiceLoader myLoader;

    public ServiceMetaData(ServiceLoader loader, MetaData parent, ManagerMetaData manager) {
        super(parent);
        this.manager = manager;
        this.myLoader = loader;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public void addAttribute(AttributeMetaData attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    public Element getOptionalConfig() {
        return this.optionalConfig;
    }

    public List getDepends() {
        return this.depends;
    }

    public void addDepends(DependsMetaData depends) {
        this.depends.add(depends);
    }

    public ManagerMetaData getManager() {
        return this.manager;
    }

    public void setManager(ManagerMetaData manager) {
        this.manager = manager;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(SERVICE_TAG_NAME)) {
            throw new DeploymentException("Tag must be service : " + element.getTagName());
        }
        this.code = ServiceMetaData.getUniqueAttribute(element, CODE_ATTRIBUTE_NAME);
        this.name = ServiceMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        Iterator attributeElements = ServiceMetaData.getChildrenByTagName(element, ATTRIBUTE_TAG_NAME);
        while (attributeElements.hasNext()) {
            AttributeMetaData attributeData = new AttributeMetaData();
            attributeData.importXML((Element)attributeElements.next());
            this.addAttribute(attributeData);
        }
        this.optionalConfig = ServiceMetaData.getOptionalChild(element, OPT_CONF_TAG_NAME);
        Iterator dependsElements = ServiceMetaData.getChildrenByTagName(element, DEPENDS_TAG_NAME);
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            DependsMetaData dependsData = new DependsMetaData(this.manager.getName());
            dependsData.importXML(dependsElement);
            this.depends.add(dependsData);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append(CODE_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.getCode());
        buf.append('}');
        return buf.toString();
    }

    public class AttributeMetaData
    extends MetaData
    implements Serializable {
        private String name;
        private String type;
        private String value;

        public AttributeMetaData() {
            super(ServiceMetaData.this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(ServiceMetaData.ATTRIBUTE_TAG_NAME)) {
                throw new DeploymentException("Tag must be attribute : " + element.getTagName());
            }
            this.name = AttributeMetaData.getUniqueAttribute(element, ServiceMetaData.NAME_ATTRIBUTE_NAME);
            this.type = AttributeMetaData.getOptionalAttribute(element, ServiceMetaData.TYPE_ATTRIBUTE_NAME);
            this.value = AttributeMetaData.getElementContent(element);
        }
    }

    public class DependsMetaData
    extends ServiceNameMetaData
    implements Serializable {
        public DependsMetaData(String manager) {
            super(ServiceMetaData.this, manager);
        }

        public DependsMetaData(String manager, String service) {
            super(ServiceMetaData.this, manager, service);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals(ServiceMetaData.DEPENDS_TAG_NAME)) {
                throw new DeploymentException("Tag must be depends : " + element.getTagName());
            }
            Element serviceElement = DependsMetaData.getOptionalChild(element, ServiceMetaData.SERVICE_TAG_NAME);
            if (serviceElement == null) {
                ServiceMetaData parent = (ServiceMetaData)this.getParent();
                if (parent != null) {
                    this.setManagerName(parent.getManager().getName());
                }
                super.importXML(element);
            } else {
                ServiceMetaData serviceData = new ServiceMetaData(ServiceMetaData.this.myLoader, this, ServiceMetaData.this.manager);
                serviceData.importXML(serviceElement);
                this.setServiceName(serviceData.getName());
                ServiceMetaData.this.manager.addService(serviceData);
                this.setManagerName(ServiceMetaData.this.manager.getName());
            }
        }
    }

    private class DependsRepositoryMetaData
    extends DependsMetaData {
        public DependsRepositoryMetaData(String manager, String service) {
            super(manager, service);
        }
    }
}

