/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ManagerMetaData
extends MetaData
implements Serializable {
    public static final String MANAGER_TAG_NAME = "manager";
    private static final String REPOSITORY_TAG_NAME = "repository";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String SHUTDOWN_HOOK_ATTRIBUTE_NAME = "shutdown-hook";
    private static final String MANAGER_NAME_ATTRIBUTE_NAME = "manager-name";
    private static final String MANAGER_PROPERTY_TAG_NAME = "manager-property";
    private String name;
    private boolean isExistShutdownHook;
    private final Map services = new HashMap();
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private ServiceLoader myLoader;
    private Properties properties = new Properties();

    public ManagerMetaData(ServiceLoader loader, MetaData parent) {
        super(parent);
        this.myLoader = loader;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public String getName() {
        if (this.name == null) {
            return "Nimbus";
        }
        return this.name;
    }

    public boolean isExistShutdownHook() {
        return this.isExistShutdownHook;
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public ServiceMetaData getService(String name) {
        return (ServiceMetaData)this.services.get(name);
    }

    public Map getServices() {
        return this.services;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public void addService(ServiceMetaData service) {
        this.services.put(service.getName(), service);
    }

    public void importXML(Element element) throws DeploymentException {
        Element messageElement;
        Element logElement;
        Element repositoryElement;
        super.importXML(element);
        if (!element.getTagName().equals(MANAGER_TAG_NAME)) {
            throw new DeploymentException("Tag must be manager : " + element.getTagName());
        }
        this.name = ManagerMetaData.getOptionalAttribute(element, NAME_ATTRIBUTE_NAME);
        String shutdownHook = ManagerMetaData.getOptionalAttribute(element, SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        if (shutdownHook != null && shutdownHook.length() != 0) {
            this.isExistShutdownHook = Boolean.valueOf(shutdownHook);
        }
        if ((repositoryElement = ManagerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME)) != null) {
            this.repository = new ServiceNameMetaData(this, this.getName());
            this.repository.importXML(repositoryElement);
        }
        if ((logElement = ManagerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            this.log = new ServiceNameMetaData(this, this.getName());
            this.log.importXML(logElement);
        }
        if ((messageElement = ManagerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            this.message = new ServiceNameMetaData(this);
            this.message.importXML(messageElement);
        }
        Iterator propElements = ManagerMetaData.getChildrenByTagName(element, MANAGER_PROPERTY_TAG_NAME);
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            this.properties.setProperty(ManagerMetaData.getUniqueAttribute(propElement, NAME_ATTRIBUTE_NAME), ManagerMetaData.getElementContent(propElement));
        }
        Iterator serviceElements = ManagerMetaData.getChildrenByTagName(element, "service");
        while (serviceElements.hasNext()) {
            ServiceMetaData serviceData = new ServiceMetaData(this.myLoader, this, this);
            serviceData.importXML((Element)serviceElements.next());
            this.addService(serviceData);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append(SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.isExistShutdownHook);
        buf.append('}');
        return buf.toString();
    }
}

