/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchIndexPropertyException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;

public class IndexedProperty
extends SimpleProperty
implements Serializable {
    private static final String MSG_00001 = "Illegal IndexedProperty : ";
    private static final String MSG_00002 = "Length of property literal must be not null.";
    protected static final String GET_METHOD_NAME = "get";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{Integer.TYPE};
    protected static final String SET_METHOD_NAME = "set";
    protected int index;
    protected transient Map indexedReadMethodCache = new HashMap();
    protected transient Map indexedWriteMethodCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;

    public IndexedProperty() {
    }

    public IndexedProperty(String name) throws IllegalArgumentException {
        this.setPropertyName(name);
    }

    public IndexedProperty(String name, int index) throws IllegalArgumentException {
        this.setPropertyName(name);
        this.index = index;
    }

    public String getPropertyName() {
        return super.getPropertyName() + '[' + this.index + ']';
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.property = prop;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int startIndexedDelim = prop.indexOf(91);
        int endIndexedDelim = prop.indexOf(93);
        if (startIndexedDelim == -1 || endIndexedDelim == -1 || endIndexedDelim - startIndexedDelim <= 1 || endIndexedDelim != prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        String indexStr = prop.substring(startIndexedDelim + 1, endIndexedDelim);
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.setPropertyName(prop.substring(0, startIndexedDelim));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.getNoIndexedProperty(obj, readMethod);
        }
        if (this.indexedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.indexedReadMethodCache.get(clazz);
            return this.getIndexedProperty(obj, readMethod);
        }
        if (this.property.length() == 0) {
            return this.getIndexedObjectProperty(obj);
        }
        PropertyDescriptor descriptor = null;
        try {
            IndexedPropertyDescriptor indexedDesc;
            descriptor = this.getPropertyDescriptor(obj);
            if (descriptor instanceof IndexedPropertyDescriptor && (readMethod = (indexedDesc = (IndexedPropertyDescriptor)descriptor).getIndexedReadMethod()) != null) {
                this.indexedReadMethodCache.put(clazz, readMethod);
                return this.getIndexedProperty(obj, readMethod);
            }
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        Object prop = super.getProperty(obj);
        if (prop == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        return this.getIndexedObjectProperty(prop);
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoIndexedProperty(obj, readMethod, value);
        } else if (this.indexedWriteMethodCache.containsKey(clazz)) {
            writeMethod = (Method)this.indexedWriteMethodCache.get(clazz);
            this.setIndexedProperty(obj, writeMethod, value);
        } else if (this.property.length() == 0) {
            this.setIndexedObjectProperty(obj, value);
        } else {
            PropertyDescriptor descriptor = null;
            try {
                IndexedPropertyDescriptor indexedDesc;
                descriptor = this.getPropertyDescriptor(obj);
                if (descriptor instanceof IndexedPropertyDescriptor && (writeMethod = (indexedDesc = (IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod()) != null) {
                    this.indexedWriteMethodCache.put(clazz, writeMethod);
                    this.setIndexedProperty(obj, writeMethod, value);
                    return;
                }
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.property);
            }
            this.setIndexedObjectProperty(prop, value);
        }
    }

    protected Object getIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, new Integer(this.index));
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    protected void setIndexedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            writeMethod.invoke(obj, new Integer(this.index), value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    protected Object getNoIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = null;
        try {
            indexedObj = readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        if (indexedObj == null) {
            throw new NullIndexPropertyException(clazz, this.property);
        }
        return this.getIndexedObjectProperty(indexedObj);
    }

    protected void setNoIndexedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = null;
        try {
            indexedObj = readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        if (indexedObj == null) {
            throw new NullIndexPropertyException(clazz, this.property);
        }
        this.setIndexedObjectProperty(indexedObj, value);
    }

    protected Object getIndexedObjectProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> indexdClazz = obj.getClass();
        if (indexdClazz.isArray()) {
            if (Array.getLength(obj) <= this.index) {
                throw new NoSuchIndexPropertyException(indexdClazz, this.property, this.index);
            }
            return Array.get(obj, this.index);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            try {
                return list.get(this.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchIndexPropertyException(indexdClazz, this.property, this.index, e);
            }
        }
        Method getMethod = null;
        try {
            getMethod = indexdClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchPropertyException(indexdClazz, this.property);
        }
        if (Modifier.isPublic(getMethod.getModifiers())) {
            try {
                return getMethod.invoke(obj, new Integer(this.index));
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(indexdClazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(indexdClazz, this.property, e);
            }
        }
        throw new NoSuchPropertyException(indexdClazz, this.property);
    }

    protected void setIndexedObjectProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> indexdClazz = obj.getClass();
        if (indexdClazz.isArray()) {
            if (Array.getLength(obj) <= this.index) {
                throw new NoSuchIndexPropertyException(indexdClazz, this.property, this.index);
            }
            Array.set(obj, this.index, value);
        } else if (obj instanceof List) {
            List list = (List)obj;
            try {
                list.set(this.index, value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchIndexPropertyException(indexdClazz, this.property, this.index, e);
            }
        } else {
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            Method[] methods = indexdClazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(indexdClazz, this.property);
            }
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName())) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$Integer == null ? IndexedProperty.class$("java.lang.Integer") : class$java$lang$Integer) && !params[0].equals(Integer.TYPE) || valueClass != null && !params[1].isAssignableFrom(valueClass) || setMethod != null && !setMethod.getParameterTypes()[1].isAssignableFrom(params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(indexdClazz, this.property);
            }
            if (Modifier.isPublic(setMethod.getModifiers())) {
                try {
                    setMethod.invoke(obj, new Integer(this.index), value);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(indexdClazz, this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(indexdClazz, this.property, e);
                }
            } else {
                throw new NoSuchPropertyException(indexdClazz, this.property);
            }
        }
    }

    public String toString() {
        return "IndexedProperty{" + this.property + '[' + this.index + "]}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
        this.indexedReadMethodCache = new HashMap();
        this.indexedWriteMethodCache = new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

