import java.util.Date
import com.commentout.nihohi.Entry
import com.commentout.nihohi.PostWriteback
import org.prevayler.Prevayler

import java.nio.charset.*
import java.nio.ByteBuffer

import com.commentout.nihohi.UnicodeTool

class Post {
	Integer id
	String  name
	String  body
	
	String title
	String excerpt
	String url
	String charset = "UTF-8"
	
	List   errors = []
	Locale locale = Locale.ENGLISH
	
	Entry entry

	private prevayler
	
	Post(Prevayler p){
		prevayler = p
	}
	void setBlog_name(String bn){
		this.name = bn
	}
	writeback() {
		validate()
		entry = prevayler.system().findById(id)
		if(errors.size() > 0)
			return "entry"
		cmd = new PostWriteback(id: id, name: name, body: body, date: new Date())
		prevayler.executeCommand(cmd)
		
		return "store"
	}
	trackback(){
		buf = new StringBuffer()
		if(title != null || title != "")
			buf << "${title}\n\n"
		if(excerpt != null || excerpt != "")
			buf << "${excerpt}\n\n"
		if(url != null || url != "")
			buf << "${url}"
		this.body = buf.toString()
		
		validate()

		if(errors.size() == 0){
			this.name = new String(name.getBytes("ISO-8859-1"), charset)
			this.body = new String(body.getBytes("ISO-8859-1"), charset)
		
			cmd = new PostWriteback(id: id, name: name, body: body, date: new Date())
			prevayler.executeCommand(cmd)
		}
		return "trackback"
	}
	private validate(){
		if(id == null)
			errors << "System error; Missing id."
		if(name == null || name == "")
			errors << "Please input your name."
		if(body == null || body == "")
			errors << "Please input the body."
		if(name != null && name.size() > 40)
			errors << "The name is too long."
		if(body != null && body.size() > 2000)
			errors << "The body is too long."
	}
}