package com.commentout.nihohi

import groovy.util.GroovyTestCase
import java.util.Date
import org.prevayler.implementation.SnapshotPrevayler
import org.prevayler.Prevayler

class WeblogTest extends GroovyTestCase{
	property Weblog weblog
	property Date today = new Date()
	
	void setUp(){
		weblog = new Weblog()
		weblog.store(new Entry(category: "cat1", text: "text1",  date: today - 9))
		weblog.store(new Entry(category: "cat1", text: "text2",  date: today - 8))
		weblog.store(new Entry(category: "cat1", text: "text3",  date: today - 7))
		weblog.store(new Entry(category: "cat2", text: "text4",  date: today - 6))
		weblog.store(new Entry(category: "cat2", text: "text5",  date: today - 5))
		weblog.store(new Entry(category: "cat2", text: "text6",  date: today - 4))
		weblog.store(new Entry(category: "cat3", text: "text7",  date: today - 3))
		weblog.store(new Entry(category: "cat3", text: "text8",  date: today - 2))
		weblog.store(new Entry(category: "cat3", text: "text9",  date: today - 1))
		weblog.store(new Entry(category: "cat3", text: "text10", date: today))
	}
	void testFindByCategory(){
		cat1 = weblog.findByCategory("cat1")
		cat2 = weblog.findByCategory("cat2")
		cat3 = weblog.findByCategory("cat3")
		
		assert 3 == cat1.size()
		assert 3 == cat2.size()
		assert 4 == cat3.size()
		
		assert  1 == cat1[0].id
		assert  2 == cat1[1].id
		assert  3 == cat1[2].id
		assert  4 == cat2[0].id
		assert  5 == cat2[1].id
		assert  6 == cat2[2].id
		assert  7 == cat3[0].id
		assert  8 == cat3[1].id
		assert  9 == cat3[2].id
		assert 10 == cat3[3].id
	}	
	void testFindByDate(){
		assert  1 == weblog.findByDate(today - 9)[0].id
		assert  2 == weblog.findByDate(today - 8)[0].id
		assert  3 == weblog.findByDate(today - 7)[0].id
		assert  4 == weblog.findByDate(today - 6)[0].id
		assert  5 == weblog.findByDate(today - 5)[0].id
		assert  6 == weblog.findByDate(today - 4)[0].id
		assert  7 == weblog.findByDate(today - 3)[0].id
		assert  8 == weblog.findByDate(today - 2)[0].id
		assert  9 == weblog.findByDate(today - 1)[0].id
		assert 10 == weblog.findByDate(today)[0].id
	}
	void testFindById(){
		assert  1 == weblog.findById(1).id
		assert  2 == weblog.findById(2).id
		assert  3 == weblog.findById(3).id
		assert  4 == weblog.findById(4).id
		assert  5 == weblog.findById(5).id
		assert  6 == weblog.findById(6).id
		assert  7 == weblog.findById(7).id
		assert  8 == weblog.findById(8).id
		assert  9 == weblog.findById(9).id
		assert 10 == weblog.findById(10).id
	}
	void testFindLatest(){
		es = weblog.findLatest()
		assert 7 == es.size()
		assert 10 == es[0].id
		assert  9 == es[1].id
		assert  8 == es[2].id
		assert  7 == es[3].id
		assert  6 == es[4].id
		assert  5 == es[5].id
		assert  4 == es[6].id
		
		es = weblog.findLatest(11)
		assert 10 == es.size()
		assert 10 == es[0].id
		assert  9 == es[1].id
		assert  8 == es[2].id
		assert  7 == es[3].id
		assert  6 == es[4].id
		assert  5 == es[5].id
		assert  4 == es[6].id
		assert  3 == es[7].id
		assert  2 == es[8].id
		assert  1 == es[9].id
	}
	void testDelete(){
		weblog.delete(5)
		assert 9 == weblog.entries.size()
		assert null == weblog.findById(5)
	}
	void testStore(){
		created = new Entry(category: "new", text: "new text", date: new Date())
		weblog.store(created)
		stored = weblog.findById(11)
		assert 11 == weblog.entries.size()
		assert created === stored
		assert "new text" == stored.text
		
		stored.text = "modified text"
		weblog.store(stored)
		modified = weblog.findById(11)
		assert 11 == weblog.entries.size()
		assert created === modified
		assert "modified text" == modified.text
	}
}