package com.commentout.nihohi

import java.util.List
import org.prevayler.implementation.AbstractPrevalentSystem

class Weblog extends AbstractPrevalentSystem {
	Integer counter = 0
	List entries = []

	void delete(Integer id){
		e = findById(id)
		entries.remove(e)
	}
	void store(Entry e){
		if(e.id == null){
			e.id = ++ counter
			entries.add(e)
		}
		entries = entries.sort{a,b|
			a.date <=> b.date
		}
	}
	List findByCategory(String cat){
		return entries.findAll{e|
			e.category == cat
		}
	}
	List findByDate(Date d){
		return entries.findAll{e|
			e.date.year  == d.year  &&
			e.date.month == d.month &&
			e.date.date  == d.date
		}
	}
	Entry findById(Integer id){
		return entries.find{e|
			e.id == id
		}
	}
	List findLatest(int num = 7){
		return entries.reverse()[0 ... num]
	}
}
