/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.util.Code;
import org.mortbay.util.Credential;
import org.mortbay.util.Password;
import org.mortbay.util.Resource;

public class HashUserRealm
extends HashMap
implements UserRealm,
SSORealm,
Externalizable {
    public static final String __SSO = "org.mortbay.http.SSO";
    private String _realmName;
    private String _config;
    protected HashMap _roles = new HashMap(7);
    private SSORealm _ssoRealm;

    public HashUserRealm() {
    }

    public HashUserRealm(String name) {
        this._realmName = name;
    }

    public HashUserRealm(String name, String config) throws IOException {
        this._realmName = name;
        this.load(config);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._realmName);
        out.writeObject(this._config);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._realmName = (String)in.readObject();
        this._config = (String)in.readObject();
        if (this._config != null) {
            this.load(this._config);
        }
    }

    public void load(String config) throws IOException {
        this._config = config;
        Code.debug((Object)"Load ", this, (Object)" from ", config);
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.load(resource.getInputStream());
        Iterator<Map.Entry<Object, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String username = entry.getKey().toString().trim();
            String credentials = entry.getValue().toString().trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            this.put(username, credentials);
            if (roles == null || roles.length() <= 0) continue;
            StringTokenizer tok = new StringTokenizer(roles, ", ");
            while (tok.hasMoreTokens()) {
                this.addUserToRole(username, tok.nextToken());
            }
        }
    }

    public void setName(String name) {
        this._realmName = name;
    }

    public String getName() {
        return this._realmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPrincipal authenticate(String username, Object credentials, HttpRequest request) {
        KnownUser user;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            user = (KnownUser)super.get(username);
        }
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    public void disassociate(UserPrincipal user) {
    }

    public UserPrincipal pushRole(UserPrincipal user, String role) {
        if (user == null) {
            user = new User();
        }
        return new WrappedUser(user, role);
    }

    public UserPrincipal popRole(UserPrincipal user) {
        WrappedUser wu = (WrappedUser)user;
        return wu.getUserPrincipal();
    }

    public synchronized Object put(Object name, Object credentials) {
        if (credentials instanceof UserPrincipal) {
            return super.put(name.toString(), credentials);
        }
        if (credentials instanceof Password) {
            return super.put(name, new KnownUser(name.toString(), (Password)credentials));
        }
        if (credentials != null) {
            return super.put(name, new KnownUser(name.toString(), Credential.getCredential(credentials.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String userName, String roleName) {
        HashSet<String> userSet = (HashSet<String>)this._roles.get(roleName);
        if (userSet == null) {
            userSet = new HashSet<String>(11);
            this._roles.put(roleName, userSet);
        }
        userSet.add(userName);
    }

    public synchronized boolean isUserInRole(UserPrincipal user, String roleName) {
        if (user == null || ((User)user).getUserRealm() != this) {
            return false;
        }
        HashSet userSet = (HashSet)this._roles.get(roleName);
        return userSet != null && userSet.contains(user.getName());
    }

    public void logout(UserPrincipal user) {
    }

    public String toString() {
        return "Realm[" + this._realmName + "]";
    }

    public void dump(PrintStream out) {
        out.println(this + ":");
        out.println(super.toString());
        out.println(this._roles);
    }

    public SSORealm getSSORealm() {
        return this._ssoRealm;
    }

    public void setSSORealm(SSORealm ssoRealm) {
        this._ssoRealm = ssoRealm;
    }

    public Credential getSingleSignOn(HttpRequest request, HttpResponse response) {
        if (this._ssoRealm != null) {
            return this._ssoRealm.getSingleSignOn(request, response);
        }
        return null;
    }

    public void setSingleSignOn(HttpRequest request, HttpResponse response, UserPrincipal principal, Credential credential) {
        if (this._ssoRealm != null) {
            this._ssoRealm.setSingleSignOn(request, response, principal, credential);
        }
    }

    public void clearSingleSignOn(String username) {
        if (this._ssoRealm != null) {
            this._ssoRealm.clearSingleSignOn(username);
        }
    }

    private class WrappedUser
    extends User {
        private UserPrincipal user;
        private String role;

        private WrappedUser(UserPrincipal user, String role) {
            this.user = user;
            this.role = role;
        }

        private UserPrincipal getUserPrincipal() {
            return this.user;
        }

        public String getName() {
            return "role:" + this.role;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String role) {
            return this.role.equals(role);
        }
    }

    private class KnownUser
    extends User {
        private String _userName;
        private Credential _cred;

        KnownUser(String name, Credential credential) {
            this._userName = name;
            this._cred = credential;
        }

        private boolean authenticate(Object credentials) {
            return this._cred != null && this._cred.check(credentials);
        }

        public String getName() {
            return this._userName;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String role) {
            return HashUserRealm.this.isUserInRole(this, role);
        }
    }

    private class User
    implements UserPrincipal {
        List roles = null;

        private User() {
        }

        private UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

