# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: test_xmlconfig.rb,v 1.1.1.1 2003/12/25 11:30:13 takai Exp $

require 'ostruct'
require 'rubyunit'
require 'tempfile'
require 'tudura'
require 'tudura/xmlconfig'

include Tudura

XML = DATA.read

class MyObject
  attr_accessor :one, :two, :three, :array, :hash, :ref
end

class XMLContextTest < RUNIT::TestCase
  def setup
    @context = XMLContext.new(XML).configure
  end
  def test_fetch
    obj = @context.fetch(:obj)
    ref_obj = @context.fetch(:ref_obj)
    
    assert_kind_of MyObject,   obj
    assert_kind_of Array,      obj.array
    assert_kind_of OpenStruct, obj.array[3]
    assert_kind_of Hash,       obj.hash
    assert_kind_of OpenStruct, obj.hash['ref']
    assert_kind_of OpenStruct, obj.ref

    assert_equals 1,       obj.one
    assert_equals 2.0,     obj.two
    assert_equals "three", obj.three
    assert_equals 4,       obj.array[0]
    assert_equals 5.0,     obj.array[1]
    assert_equals "six",   obj.array[2]
    assert_equals "value", obj.array[3].value
    assert_equals 7,       obj.hash['seven']
    assert_equals 8.0,     obj.hash['eight']
    assert_equals "nine",  obj.hash['nine']
    assert_equals "value", obj.hash['ref'].value
    assert_equals "value", obj.ref.value
    assert_equals "value", ref_obj.value

    assert_same ref_obj, obj.ref
    assert_same ref_obj, obj.array[3]
    assert_same ref_obj, obj.hash['ref']
  end
end

class XMLConfigTest < RUNIT::TestCase
  def setup
    @config = XMLConfig.new XML
  end
  def test_parse
    defs = @config.parse
    
    assert_equals "obj".intern,     defs[0].key
    assert_equals "ref_obj".intern, defs[1].key

    assert_equals "one",   defs[0].props[0].name
    assert_equals "two",   defs[0].props[1].name
    assert_equals "three", defs[0].props[2].name
    assert_equals "array", defs[0].props[3].name
    assert_equals "hash",  defs[0].props[4].name
    assert_equals "ref",   defs[0].props[5].name
    assert_equals "value", defs[1].props[0].name

    assert_kind_of LiteralValue,  defs[0].props[0].value
    assert_kind_of LiteralValue,  defs[0].props[1].value
    assert_kind_of LiteralValue,  defs[0].props[2].value
    assert_kind_of ArrayValue,    defs[0].props[3].value
    assert_kind_of HashValue,     defs[0].props[4].value
    assert_kind_of ReferenceValue,defs[0].props[5].value
  end
end

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="obj" class="MyObject" init="new">
    <property name="one"><value>1</value></property>
    <property name="two"><value>2.0</value></property>
    <property name="three"><value>three</value></property>
    <property name="array">
      <array>
        <value>4</value>
        <value>5.0</value>
        <value>six</value>
        <ref object="ref_obj"/>
      </array>
    </property>
    <property name="hash">
      <hash>
        <entry key="seven"><value>7</value></entry>
        <entry key="eight"><value>8.0</value></entry>
        <entry key="nine"><value>nine</value></entry>
        <entry key="ref"><ref object="ref_obj"/></entry>
      </hash>
    </property>
    <property name="ref"><ref object="ref_obj" /></property>
  </object>
  <object id="ref_obj">
    <property name="value"><value>value</value></property>
  </object>
</context>
