# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: xmlconfig.rb,v 1.1.1.1 2003/12/25 11:30:13 takai Exp $

require 'rexml/document'

module Tudura
  
  class XMLContext < Context
    def initialize xml
      super()
      self.defs = XMLConfig.new(xml).parse
    end
  end

  class XMLConfig
    def initialize xml
      @xml = xml
    end
    def parse
      object_defs = []
      doc = REXML::Document.new @xml
      doc.elements.each "/context/object" do |object|
	key   = object.attributes["id"]
	klass = object.attributes["class"]
	init  = object.attributes["init"]

	object_def = ObjectDef.new key, klass, init
	object.elements.each "property" do |property|
	  object_def.props << get_property_def(property)
	end
	
	object_defs << object_def
      end
      
      return object_defs
    end
    
    def get_property_def property
      name  = property.attributes["name"]
      value = get_property_value property.elements[1]
      PropertyDef.new name, value
    end

    def get_property_value child
      result = nil

      case child.name
      when 'value'
	result = LiteralValue.new child.text
      when 'array'
	result = ArrayValue.new
	child.elements.each do |elem|
	  result << get_property_value(elem)
	end
      when 'hash'
	result = HashValue.new
	child.elements.each("entry") do |elem|
	  result << Entry.new(elem.attributes["key"],
			      get_property_value(elem.elements[1]))
	end
      when 'ref'
	result = ReferenceValue.new child.attributes["object"]
      else
	raise RuntimeError.new("#{child.name} is unknown element.")
      end
      result
    end
  end
end

