# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: interceptor.rb,v 1.1 2003/12/26 03:02:26 takai Exp $

module Tudura

  module Interceptor
    def do_intercept name, args, chain
      intercept name, args, chain
    end
  end

  class InterceptorProxy
    attr_accessor :interceptors
    def initialize interceptors = []
      self.interceptors = interceptors
    end
    def proceed name, args
      chain = InterceptorChain.new interceptors
      chain.proceed name, args
    end
    def method_missing name, *args
      proceed name, args
    end
  end

  class ObjectInterceptor
    include Interceptor
    def initialize obj
      @obj = obj
    end
    def intercept name, args, chain
      @obj.__send__ name, *args
    end
  end

  class InterceptorChain
    def initialize interceptors
      @interceptors = interceptors.map do |interceptor|
	if interceptor.is_a? Interceptor
	  interceptor
	else
	  ObjectInterceptor.new interceptor
	end
      end
    end
    def proceed name, args
      filter = @interceptors.shift
      if filter
	filter.do_intercept name, args, self
      end
    end
  end
end
