# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: config.rb,v 1.1 2003/12/26 15:21:07 takai Exp $

module Tudura

  class ObjectDef
    attr_writer   :key
    attr_accessor :klass, :props, :init
    def initialize key, klass = nil, init = nil, props = nil, &block
      self.key   = key
      self.klass = klass || 'OpenStruct'
      self.props = props || []
      self.init  = init  || "new"
      
      if block_given?
	block.call self.props
      end
    end
    def key
      @key.intern
    end
    def instatiate
      load_class(klass).__send__ init.intern
    end
    def setup obj
      props.each do |prop| prop.set obj end
    end
    def load_class(class_name)
      ObjectSpace.each_object(Class){|c|
	return c if c.name == class_name
      }
      raise "Class #{class_name} not found"
    end
  end
  
  class PropertyDef
    attr_accessor :name, :value
    def initialize name = nil, value = nil
      self.name, self.value = name, value
    end
    def set obj
      obj.__send__ "#{name}=", value.entity
    end
  end

  class LiteralValue
    attr_accessor :value
    def initialize value = nil
      self.value = value
    end
    def entity
      return case value
	     when /^\d+$/
	       value.to_i
	     when /^\d+\.\d+$/
	       value.to_f
	     else
	       value.to_s
	     end
    end
  end

  class ArrayValue
    attr_accessor :values
    def initialize values = []
      self.values = values
    end
    def << value
      values << value
    end
    def entity
      values.inject [] do |result, value|
	result << value.entity
      end
    end
  end

  class Entry
    attr_accessor :key, :value
    def initialize key, value
      self.key, self.value = key, value
    end
  end

  class HashValue
    attr_accessor :entries
    def initialize entries = []
      self.entries = entries
    end
    def << entry
      self.entries << entry
    end
    def entity
      entries.inject Hash.new do |result, entry|
	result.store entry.key, entry.value.entity
	result
      end
    end
  end

  class ReferenceValue
    @@context = nil
    def ReferenceValue.context
      @@context
    end
    def ReferenceValue.context= context
      @@context = context
    end

    attr_accessor :key

    def initialize key = ''
      self.key = key
    end
    def entity
      ReferenceValue.context.fetch key.intern
    end
  end
end
