# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: interceptor.rb,v 1.1 2003/12/26 03:02:26 takai Exp $

require 'tudura'
require 'tudura/xmlconfig'
require 'tudura/interceptor'

class LoggingInterceptor
  include Tudura::Interceptor
  
  def intercept name, args, chain
    result = chain.proceed name, args
    if result
      puts "user #{args.first} is logged in."
    else
      puts "user login failure"
    end
    result
  end
end

class Authorization
  attr_accessor :passwd

  def authorize name, password
    passwd[name] == password
  end
end

context = Tudura::XMLContext.new(DATA.read).configure

auth = context.fetch :auth
auth_with_logging = context.fetch :auth_with_logging

p auth.authorize('user1', 'password')                 # => true
p auth.authorize('user1', 'wrong_pass')               # => false
p auth_with_logging.authorize('user2', 'open_sesame') # => true
p auth_with_logging.authorize('user2', 'wrong_pass')  # => false

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="auth"   class="Authorization">
    <property name="passwd">
      <hash>
        <entry key="user1"><value>password</value></entry>
        <entry key="user2"><value>open_sesame</value></entry>
      </hash>
    </property>
  </object>
  <object id="logger" class="LoggingInterceptor" />
  <object id="auth_with_logging" class="Tudura::InterceptorProxy">
    <property name="interceptors">
      <array>
        <ref object="logger" />
        <ref object="auth" />
      </array>
    </property>
  </object>
</context>
