# -*- mode: ruby; coding: utf-8-unix -*-
# $Id: hello_i18n.rb,v 1.1 2003/12/27 06:58:24 takai Exp $

require 'tudura'
require 'tudura/xmlconfig'

KCODE = 'u'

class Japanese
  def introduce
    "こんにちは、私の名前は%sです。"
  end
end
class English
  def introduce
    "Hello, my name is %s."
  end
end

class Person
  attr_accessor :name, :lang
  def introduce
    lang.introduce % name
  end
end

context = Tudura::XMLContext.new(DATA.read).configure
puts context.fetch(:alice).introduce # => Hello, my name is Alice.
puts context.fetch(:tarou).introduce # => こんにちは、私の名前は太郎です。

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="ja" class="Japanese" />
  <object id="en" class="English" />
  <object id="alice" class="Person">
    <property name="lang"><ref object="en" /></property>
    <property name="name"><value>Alice</value></property>
  </object>
  <object id="tarou" class="Person">
    <property name="lang"><ref object="ja" /></property>
    <property name="name"><value>太郎</value></property>
  </object>
</context>
