﻿// Copyright (c) 2008 - 2009 rankingloid
//
// under GNU General Public License Version 2.
//
using System;
using System.Drawing;
using System.Windows.Forms;
using IJLib;

namespace nicorank
{
    public partial class FormLayout : Form
    {
        public bool is_changed = false;
        private string rank_file_ = "";

        public FormLayout()
        {
            InitializeComponent();
        }

        private void FormLayout_Load(object sender, EventArgs e)
        {
            try
            {
                string str = IJFile.Read(rank_file_);
                string[] line = IJStringUtil.SplitWithCRLF(str);
                textBoxRankData.Text = line[0];
                for (int i = 1; i <= 4 && i < line.Length; ++i)
                {
                    textBoxRankData.AppendText("\r\n" + line[i]);
                }
            }
            catch (Exception)
            {
                textBoxRankData.Text = "sm1234567	1	9,312	657	415	0.93	4.45	14,077" +
                    "	タイトル見本タイトル見本タイトル見本タイトル見本	" +
                    "2008年04月01日 01：01：00	sm2891745.png";
            }
        }

        private void buttonLoad_Click(object sender, EventArgs e)
        {
            Graphics graphics = null;
            try
            {
                Layout layout = new Layout(textBoxLayout.Text);
                pictureBox1.Width = layout.GetWidth();
                pictureBox1.Height = layout.GetHeight();
                pictureBox1.Image = new Bitmap(pictureBox1.Width, pictureBox1.Height);
                graphics = Graphics.FromImage(pictureBox1.Image);
                layout.DrawPicture(graphics, textBoxRankData.Text, true);
            }
            catch (System.Exception err)
            {
                MessageBox.Show("エラー:\n" + err.Message, "エラー");
            }
            finally
            {
                if (graphics != null)
                {
                    graphics.Dispose();
                }
            }
        }

        private void buttonLayoutSave_Click(object sender, EventArgs e)
        {
            DialogResult result = DialogResult.Yes;
            if (System.IO.File.Exists(textBoxLayoutFile.Text))
            {
                result = MessageBox.Show("レイアウトファイルを上書きしますか？", "確認", MessageBoxButtons.YesNo);
            }
            if (result == DialogResult.Yes)
            {
                IJFile.Write(textBoxLayoutFile.Text, textBoxLayout.Text);
                is_changed = false;
            }
        }

        private void textBoxLayout_TextChanged(object sender, EventArgs e)
        {
            is_changed = true;
        }

        private void FormLayout_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (is_changed)
            {
                DialogResult result;
                if (System.IO.File.Exists(textBoxLayoutFile.Text))
                {
                    result = MessageBox.Show("レイアウトファイルを上書き保存しますか？", "確認", MessageBoxButtons.YesNoCancel);
                }
                else
                {
                    result = MessageBox.Show("レイアウトファイルを保存しますか？", "確認", MessageBoxButtons.YesNoCancel);
                }
                if (result == DialogResult.Yes)
                {
                    IJFile.Write(textBoxLayoutFile.Text, textBoxLayout.Text);
                }
                else if (result == DialogResult.Cancel)
                {
                    e.Cancel = true;
                }
            }
        }

        private void buttonPicSave_Click(object sender, EventArgs e)
        {
            string old_path = System.IO.Directory.GetCurrentDirectory();
            DialogResult result = saveFileDialogPic.ShowDialog();
            System.IO.Directory.SetCurrentDirectory(old_path);
            if (result == DialogResult.OK)
            {
                try
                {
                    pictureBox1.Image.Save(saveFileDialogPic.FileName, System.Drawing.Imaging.ImageFormat.Png);
                }
                catch (System.Exception err)
                {
                    MessageBox.Show("エラー:\n" + err.Message, "エラー");
                }
            }
        }

        public void SetLayoutFile(string filename)
        {
            textBoxLayoutFile.Text = filename;
        }

        public void SetRankFile(string filename)
        {
            rank_file_ = filename;
        }

        private void buttonLayoutLoad_Click(object sender, EventArgs e)
        {
            if (System.IO.File.Exists(textBoxLayoutFile.Text))
            {
                DialogResult result = DialogResult.Yes;
                if (textBoxLayout.Text != "")
                {
                    result = MessageBox.Show("レイアウトファイルを読み込みますか？", "確認", MessageBoxButtons.YesNo);
                }
                if (result == DialogResult.Yes)
                {
                    textBoxLayout.Text = IJFile.Read(textBoxLayoutFile.Text);
                    is_changed = false;
                }
            }
            else
            {
                MessageBox.Show("レイアウトファイルが存在しません。", "確認");
            }
        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            labelCoordinate.Text = "(" + e.X.ToString() + ", " + e.Y.ToString() + ")";
        }

        private void pictureBox1_MouseLeave(object sender, EventArgs e)
        {
            labelCoordinate.Text = "";
        }
    }
}
