using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace HydeCalc
{
	/// <summary>
	/// Form1 ̊Tv̐łB
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Drawing.Icon _NotifyIcon01	= null;
		private bool				_SystemShutdown = false;

		private NumericTextBox textBox1;
		private NumericTextBox textBox2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.NotifyIcon notifyIcon1;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.ComponentModel.IContainer components;

		enum WindowsMessage : int {
			QueryEndSession = 0x11
		}

		protected override void WndProc(ref Message m) {
			if (m.Msg == (int)WindowsMessage.QueryEndSession) {
				_SystemShutdown = true;
			}
			base.WndProc (ref m);
		}

		public Form1()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//

			System.Reflection.Assembly asm = null;
			try {
				asm = System.Reflection.Assembly.GetExecutingAssembly();
				_NotifyIcon01 = new Icon(asm.GetManifestResourceStream("HydeCalc.Icon2.ico"));
			}
			finally {
				asm = null;
			}


		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.textBox1 = new HydeCalc.NumericTextBox();
			this.textBox2 = new HydeCalc.NumericTextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.notifyIcon1 = new System.Windows.Forms.NotifyIcon(this.components);
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(8, 8);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(40, 19);
			this.textBox1.TabIndex = 0;
			this.textBox1.Text = "";
			this.textBox1.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBox1_KeyPress);
			this.textBox1.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(80, 8);
			this.textBox2.Name = "textBox2";
			this.textBox2.ReadOnly = true;
			this.textBox2.Size = new System.Drawing.Size(40, 19);
			this.textBox2.TabIndex = 1;
			this.textBox2.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(48, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 23);
			this.label1.TabIndex = 2;
			this.label1.Text = "cm";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(120, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(32, 23);
			this.label2.TabIndex = 3;
			this.label2.Text = "hyde";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// notifyIcon1
			// 
			this.notifyIcon1.ContextMenu = this.contextMenu1;
			this.notifyIcon1.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon1.Icon")));
			this.notifyIcon1.Text = "notifyIcon1";
			this.notifyIcon1.Visible = true;
			this.notifyIcon1.DoubleClick += new System.EventHandler(this.notifyIcon1_DoubleClick);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "I";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(150, 37);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.textBox2);
			this.Controls.Add(this.textBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "HydeCalc";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.SizeChanged += new System.EventHandler(this.Form1_SizeChanged);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			System.Threading.Mutex m = new System.Threading.Mutex(false, "HydeCalc");
			if (m.WaitOne(0, false) == true) {
				Application.Run(new Form1());
			}
			System.GC.KeepAlive(m);
		}

		private void textBox1_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e) {
			if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b') {
				e.Handled = true;
			}
		}

		private void textBox1_TextChanged(object sender, System.EventArgs e) {
			if (textBox1.Text != "" && textBox1.Text != "0") {
				textBox2.Text = (double.Parse(textBox1.Text) / 156).ToString("0.00");
			} else {
				textBox2.Text = "";
			}
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e) {
			if (_SystemShutdown) {
				return;
			}
			// Window\
			e.Cancel = true;
			this.Visible = false;
		}

		private void Form1_SizeChanged(object sender, System.EventArgs e) {
			if (this.Visible == true && this.WindowState == FormWindowState.Minimized) {
				this.Visible = false;
			}
		}

		private void menuItem1_Click(object sender, System.EventArgs e) {
			Application.Exit();
		}

		private void notifyIcon1_DoubleClick(object sender, System.EventArgs e) {
			this.Visible = true;
			if (this.WindowState == FormWindowState.Minimized) {
				this.WindowState = FormWindowState.Normal;
				this.Activate();
			}
		}
	}

	public class NumericTextBox : TextBox {
		const int WM_PASTE = 0x302;

		protected override void WndProc(ref Message m) {
			if (m.Msg == WM_PASTE) {
				IDataObject iData = Clipboard.GetDataObject();
				//񂪃Nbv{[hɂ邩
				if (iData.GetDataPresent(DataFormats.Text)) {
					string clipStr = (string) iData.GetData(DataFormats.Text);
					//Nbv{[h̕񂪐ׂ
					if (!System.Text.RegularExpressions.Regex.IsMatch(
						clipStr,
						@"^\d+$"))
						return;
				}
			}

			base.WndProc(ref m);
		}
	}
}
