#ifndef WAKA_H
#define WAKA_H

/*
  â̊Ǘ
  Satofumi KAMIMURA
  $Id$

  UTF16 `̘ãf[^
*/

#include <SDL.h>
#include <iostream>


// ãf[^
typedef struct {
  int id;
  Uint16 kanji[5][9];
  Uint16 yomi[5][9];
  char kimariji;
} wakaResource_t;


class WakaResource {
  bool kimarijiSorted;
  int unsorted_index;
  int kimariji_index;
  int unsortedArray[100];
  int kimarijiArray[100];

public:
  static wakaResource_t getWakaData(int no);

  static Uint32 wakaStrValue(int id);
  void clearWakaInfo(void);
  void unsort(void);
  void kimarijiSort(void);
  void setLearnIdSet(int id, int width);
  wakaResource_t getUnsortedWakaInfo(void);
  int getKimarijiOrderWakaId(void);
  WakaResource();
  ~WakaResource() {};
};


class WakaError {
public:
  virtual void debug_print(void) const {
    fprintf(stderr, "Waka error\n");
  }
};


class Out_Of_Range : public WakaError {
  int out_id;

public:
  Out_Of_Range(int id) { out_id = id; }
  virtual void degug_print(void) const {
    fprintf(stderr, "Out of range : %d\n", out_id);
 }
};

#endif /* !WAKA_H */
