/*
  ڂ̑I
  Satofumi KAMIMURA
  $Id$
*/

#include "titleSelect.h"


// ACRAڏw肵ď
TitleSelect::TitleSelect(const char *iconFile, titleResource_t *tResource,
			 FontCtrl& fnt, int defaultSelect)
  : spaceHeight(0), spaceWidth(0), selected(defaultSelect), maxSelection(0),
    maxSurfaceWidth(0), totalSurfaceHeight(0) {

  // ACR摜̓ǂݍ
  // sAO𓊂
  SDL_Surface *temp = SDL_LoadBMP(iconFile);
  if (!temp) {
    fprintf(stderr, "SDL_LoadBMP: %s\n", SDL_GetError());
    throw No_Icon_File(iconFile);
  }
  // ̃sNZF𓧉ߐFƂĐݒ
  if (temp->format->palette) {
    SDL_SetColorKey(temp, (SDL_SRCCOLORKEY | SDL_RLEACCEL),
                    *(Uint8 *)temp->pixels);
  }
  SDL_Surface *temp2 = SDL_DisplayFormat(temp);
  if (!temp) {
    fprintf(stderr, "SDL_DisplayFormat: %s\n", SDL_GetError());
    temp2 = temp;
  }
  SDL_FreeSurface(temp);
  titleSurface.icon = temp2;

  // \̊Ԋuݒ
  spaceHeight = tResource->spaceHeight;
  spaceWidth = tResource->spaceWidth;

  // \ʒȕ
  position.x = 0;
  position.y = 0;

  // Unicode \[X SDL_Surface ̍쐬
  for (vector<Uint16 *>::iterator src = tResource->title.begin();
       src != tResource->title.end(); ++src) {
    // Unicode  SDL_Surface ɕϊ
    SDL_Surface *ttfSurface = fnt.createSurface(*src, tResource->ptSize,
						tResource->color);
    titleSurface.title.push_back(ttfSurface);
    ++maxSelection;

    if (ttfSurface->w > maxSurfaceWidth) {
      maxSurfaceWidth = ttfSurface->w;
    }
    totalSurfaceHeight += ttfSurface->h + spaceHeight;
  }
  totalSurfaceHeight -= spaceHeight;
}


// T[tFX̉
TitleSelect::~TitleSelect(void) {
  // vector Ɋi[T[tFX̉
  for (vector<SDL_Surface *>::iterator it = titleSurface.title.begin();
       it != titleSurface.title.end(); ++it) {
    SDL_FreeSurface(*it);
  }
  titleSurface.title.clear();
}


// T[tFX̕`͈͂̎擾
SDL_Rect TitleSelect::getDrawArea(void) {
  SDL_Rect area;

  area = position;
  area.w = maxSurfaceWidth + titleSurface.icon->w + spaceWidth;
  area.h = totalSurfaceHeight;

  return area;
}


// T[tFX̕\ʒuݒ
void TitleSelect::setDrawPosition(SDL_Rect *pos, int align) {

  position = *pos;

  SDL_Rect aligned;
  aligned.x = 0;
  aligned.y = 0;

  // ̈ʒu
  if ( align & MIDDLE ) {
    aligned.y = -(totalSurfaceHeight >> 1);
  } else if ( align & BOTTOM ) {
    aligned.y = -totalSurfaceHeight;
  }
  position.y += aligned.y;

  // ̈ʒu
  int totalWidth = maxSurfaceWidth + titleSurface.icon->w + spaceWidth;
  if ( align & CENTER ) {
    aligned.x = -(totalWidth >> 1);
  } else if ( align & RIGHT ) {
    aligned.x = -totalWidth;
  }
  position.x += aligned.x;
}


// T[tFX̕\
void TitleSelect::drawSurface(ScreenCtrl& scr) {

  // eIڂ̕`
  int icon_y = -1;
  int index = 0;
  SDL_Rect pos;
  pos.x = position.x + titleSurface.icon->w + spaceWidth;
  pos.y = position.y;
  for (vector<SDL_Surface *>::iterator it = titleSurface.title.begin();
       it != titleSurface.title.end(); ++it) {
    scr.blitSurface(*it, NULL, SDLResource::screen, &pos);
    if (index++ == selected) {
      icon_y = pos.y + (*it)->h/2 - titleSurface.icon->h/2;
    }
    pos.y += (*it)->h + spaceHeight;
  }

  // IACR̕`
  if (icon_y > 0) {
    pos.x = position.x;
    pos.y = icon_y;
    scr.blitSurface(titleSurface.icon, NULL,
		    SDLResource::screen, &pos);
  }
}

  
// }EXAL[͂ɂI̐ݒ
int TitleSelect::selectChange(void) {
  enum { EVENT_MAX = 10, };

  SDL_Event events[EVENT_MAX];
  
  // CxgL[́A}EXړ̃Cxg擾
  SDL_PumpEvents();
  int num = SDL_PeepEvents(events, EVENT_MAX, SDL_PEEKEVENT,
			   SDL_EVENTMASK(SDL_MOUSEMOTION) |
			   SDL_EVENTMASK(SDL_KEYDOWN));

  SDLKey key;
  SDLMod mod;
  bool haveMouseMotion = false;
  for (int i = 0; i < num; ++i) {
    switch (events[i].type) {
    case SDL_KEYDOWN:
      // J[\͂ɂȈ
      key = events[i].key.keysym.sym;
      mod = events[i].key.keysym.mod;
      if (( key == SDLK_UP ) ||
	  (( key == SDLK_p ) && ( mod & KMOD_CTRL ))) {
	if (selected > 0) {
	  --selected;
	} else if (selected < 0) {
	  selected = 0;
	}
      } else if (( key == SDLK_DOWN ) ||
		 (( key == SDLK_n ) && ( mod & KMOD_CTRL ))) {
	if (selected < maxSelection -1) {
	  ++selected;
	}
      }
      break;

    case SDL_MOUSEMOTION:
      haveMouseMotion = true;
      break;
    }
  }

  // }EXΈړɂ锻菈̋N
  if (haveMouseMotion) {
    // }EXΈʒu̎擾
    int mx, my;
    SDL_GetMouseState(&mx, &my);

    // eT[tFẌ̗Ɋ܂܂ꍇÄ̗̉ԖڂԂ
    int sx = position.x + titleSurface.icon->w + spaceWidth;
    int sy = position.y;
    int index = 0;
    for (vector<SDL_Surface *>::iterator it = titleSurface.title.begin();
	 it != titleSurface.title.end(); ++it) {

      // T[tFXɃJ[\܂ނ
      if ((mx > sx) && (mx < sx + maxSurfaceWidth) &&
	  (my > sy) && (my < sy + (*it)->h)) {
	selected = index;
	break;
      }
      sy += (*it)->h + spaceHeight;
      ++index;
    }
  }

  return selected;
}


// Iڂ̍őID擾
int TitleSelect::getMaxSelection(void) {
  return maxSelection -1;
}
