/*
  TCP/IP ǗNX
  Satofumi KAMIMURA
  $Id$
*/

#include "tcpConnect.h"
#include <stdlib.h>


int TcpConnect::send(char *buf, int size) {
  if (tcpsocket) {
    return SDLNet_TCP_Send(tcpsocket, buf, size);
  } else {
    return -1;
  }
}


int TcpConnect::recv(char *buf, int size, int timeout) {
  if (size == 0) {
    return 0;
  }
  if (!tcpsocket) {
    return -1;
  }
  if (SDLNet_CheckSockets(socketset, timeout) <= 0) {
    return -1;
  }
  
  int recieved = SDLNet_TCP_Recv(tcpsocket, buf, size);
  if (recieved == 0) {
    close();
  }
  return recieved;
}


int TcpConnect::recv(char *buf, int size) {
  return recv(buf, size, -1);
}


int TcpConnect::connect(const char *host, Uint16 port) {

  IPaddress ip;
  if (SDLNet_ResolveHost(&ip, host, port) < 0) {
    fprintf(stderr, "SDLNet_ResolveHost %s, %d: %s\n",
	    host, port, SDLNet_GetError());
    return -1;
  }

  tcpsocket = SDLNet_TCP_Open(&ip);
  if (!tcpsocket) {
    fprintf(stderr, "SDLNet_TCP_Open: %s\n", SDLNet_GetError());
    return -1;
  }

  socketset = SDLNet_AllocSocketSet(1);
  if (!socketset) {
    fprintf(stderr, "SDLNet_AllocSocketSet: %s\n", SDLNet_GetError());
    return -1;
  }

  if (SDLNet_TCP_AddSocket(socketset, tcpsocket) < 0) {
    fprintf(stderr, "SDLNet_TCP_AddSocket: %s\n", SDL_GetError());
    return -1;
  }
  
  return 0;
}


TcpConnect::TcpConnect(const char *host, Uint16 port)
  : tcpsocket(NULL), socketset(NULL) {
  static bool init = false;
  if ( init == false ) {
    init = true;
    if (SDLNet_Init() < 0) {
      fprintf(stderr, "SDLNet_Init: %s\n", SDLNet_GetError());
    }    
  }
  connect(host, port);
}


void TcpConnect::close(void) {
  if (socketset) {
    SDLNet_TCP_DelSocket(socketset, tcpsocket);
    SDLNet_FreeSocketSet(socketset);
    socketset = NULL;
  }
  
  if (tcpsocket) {
    SDLNet_TCP_Close(tcpsocket);
    tcpsocket = NULL;
  }
}


TcpConnect::~TcpConnect(void) {
  close();
  SDLNet_Quit();
}
