/*
  ʕ\p̓̓f[^Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include "resultData.h"
#include <math.h>


// o^f[^Ԃ
int ResultData::getDataNum(void) {
  return totalNum;
}


// ŌԂ [hits]
int ResultData::getTotalPressedNum(void) {
  return totalPressedNum;
}


// ԂԂ [msec]
int ResultData::getTotalSpentTime(void) {
  return totalSpentTime;
}


// ~X͐Ԃ [hits]
int ResultData::getTotalMiss(void) {
  return totalMiss;
}


// ͂Jnn߂Ԃ̕ςԂ [msec]
int ResultData::getStartDelayTotal(void) {
  return startDelayTotal;
}


// ϓ͑xԂ [hits/min]
double ResultData::getPressedNumPerMinute(void) {
  return ((totalTypingTime == 0) ?
	  0 : totalPressedNum * 60000.0 / totalTypingTime);
}


// ͊JnxaID Ԃ
void ResultData::getSlowInputWakaId(int ids[], int idnums) {

  for (int i = 0; i < idnums; ++i) {
    ids[i] = startDelayID[i];
  }
}



int ResultData::getTotalScore(void) {
  return totalScore;
}


int ResultData::getKimarijiScore(void) {
  return kimarijiScore;
}


// ʃf[^̒ǉ
void ResultData::addData(resultData_t *data) {
  result.push_back(*data);
}


// \̃f[^̏
void ResultData::clearResultStruct(resultData_t *rd, int id, int kimariji) {
  rd->spentTime = 0;
  rd->pressedNum = 0;
  rd->startDelay = INT_MIN+1;
  rd->deletePressed = 0;
  rd->id = id;
  rd->kimariji = kimariji;
}


// oϐ̏
void ResultData::clearTotalInfo(void) {
  totalSpentTime = 0;
  totalTypingTime = 0;
  totalPressedNum = 0;
  totalMiss = 0;
  startDelayTotal = 0;
  totalScore = 0;
  kimarijiScore = 0;
}


static void swap(int *a, int *b) {
  int t = *a;
  *a = *b;
  *b = t;
}


// ʂvZ
void ResultData::profile(void) {

  enum {
    BASE_SCORE = 2000,
    BASE_TIME_OFFSET = 10000,
    DELAY_TIME = 3500,
    FAST_INPUT_SCORE = 1000,
  };
  
  clearTotalInfo();
  totalNum = result.size();

  // avZ
  int index = 0;
  int startDelayTime[100];
  for (vector<resultData_t>::iterator it = result.begin();
       it != result.end(); ++it) {

    totalSpentTime += it->spentTime;
    totalTypingTime += it->spentTime - it->startDelay;
    totalPressedNum += it->pressedNum;
    totalMiss += it->deletePressed;
    startDelayTotal += it->startDelay;

    totalScore += BASE_SCORE - BASE_SCORE / (BASE_TIME_OFFSET + it->spentTime);

    // ͊Jnꍇ̒ǉ_
    int kimarijiBonus = (int)((DELAY_TIME + it->kimariji * 2000/5
			       - it->startDelay) * FAST_INPUT_SCORE / 1000.0);
    totalScore += (kimarijiBonus > 0) ? kimarijiBonus : 0;
    kimarijiScore += it->kimarijiSubScore;

    // ̓͊Jnx̊i[
    startDelayID[index] = it->id;
    startDelayTime[index] = it->startDelay - it->kimariji * 2000/5;
    ++index;
  }
  // ͊ԈႢȂꍇ̒ǉ_
  int addBonus = totalScore;
  int kimarijiBonus = kimarijiScore;
  for (int i = 0; (i < totalMiss) && (addBonus > 1); ++i) {
    addBonus = addBonus * 2 / 3;
    kimarijiBonus = kimarijiBonus * 2 / 3;
  }
  totalScore += addBonus;
  kimarijiScore += kimarijiBonus;

  // ͊JnԂɂă\[g
  for (int i = 0; i < index; ++i) {
    int now_max = INT_MIN;
    int now_index = i;
    for (int j = i; j < index; ++j) {
      if (now_max < startDelayTime[j]) {
	now_max = startDelayTime[j];
	now_index = j;
      }
    }
    // 
    swap(&startDelayID[now_index], &startDelayID[i]);
    swap(&startDelayTime[now_index], &startDelayTime[i]);
  }
}


ResultData::ResultData(void) {
  result.clear();
}
