/*
  ܂̊ǗNX
  Satofumi KAMIMURA
  $Id$
*/

#include "kimarijiManage.h"
#include <algorithm>

using namespace std;


// ܂莚̃TuO[v
void KimarijiManage::kimarijiGroupInit(kimarijiGroup_t *kg) {
  kg->numOfDiff = 0;
  kg->id.clear();
}


void KimarijiManage::initKimarijiInfo(void) {
  totalIndex = 0;
  largeIndex = firstCharGroup.begin() + 1;
  subIndex = largeIndex->id.begin();
}


// random_shuffle p
static int randValue(int max) {
  return (int)(1.0 * max * rand() / (RAND_MAX+1.0));
}


// т_
void KimarijiManage::randamize(int seed) {

  srand(seed);

  // TuO[v_
  for(vector<kimarijiGroup_t>::iterator git = firstCharGroup.begin();
      git != firstCharGroup.end(); ++git) {
    random_shuffle(git->id.begin(), git->id.end(), randValue);
  }

  // O[v_
  random_shuffle(firstCharGroup.begin() +1, firstCharGroup.end(), randValue);
  
  initKimarijiInfo();
}


// wԖڂ܂ł̕ǂ]
bool KimarijiManage::wakaCmp(Uint32 a, Uint32 b, int n) {

  // Sڈȍ~قȂ̂́APgȏ㑶݂ȂƂɈˑ
  int shift = (n > 4) ? 4 : n;
  return (a >> 8*(4-shift)) == (b >> 8*(4-shift));
}


// ܂莚̘aID 擾
int KimarijiManage::getKimarijiWakaId(void) {
  if (totalIndex++ > 99) {
    return -1;
  }

  int id = *(subIndex++);
  if (subIndex == largeIndex->id.end()) {
    largeIndex++;
    subIndex = largeIndex->id.begin();
  }
  
  return id;
}


// w肵 aID O[v̘aID Ԃ
void KimarijiManage::getKimarijiGropuIds(vector<int>& ids, int id) {

  if (id > 99) {
    ids.clear();
    return;
  }
  
  // T
  vector<kimarijiGroup_t>::iterator git;
  vector<int>::iterator sit;
  for(git = firstCharGroup.begin();
      git != firstCharGroup.end(); ++git) {
    for (sit = git->id.begin();
	 sit != git->id.end(); ++sit) {
      if (*sit == id) {
	// TuO[vɑ ID Ԃ{
	ids = git->id;
	return;
      }
    }
  }
}


// ܂薈ɃO[v쐬
KimarijiManage::KimarijiManage(WakaResource& waka) {
  
  // a̎܂莚Ƀ\[g
  waka.kimarijiSort();
  
  Uint32 pre_strValue = 0;
  kimarijiGroup_t kg;
  kg.numOfDiff = 4;
  for (int i = 0; i < 100; ++i) {
    int id = waka.getKimarijiOrderWakaId();
    Uint32 strValue = waka.wakaStrValue(id);
    wakaResource_t wr = waka.getWakaData(id);

    if (wakaCmp(strValue, pre_strValue, kg.numOfDiff -1) &&
	(kg.numOfDiff == wr.kimariji)) {
      // ̃TuO[vɒǉ
      kg.id.push_back(id);

    } else {
      // ̃TuO[vO[vɒǉ
      firstCharGroup.push_back(kg);
      
      // VKTuO[v̍쐬
      kimarijiGroupInit(&kg);
      kg.id.push_back(id);

      kg.numOfDiff = wr.kimariji;
      pre_strValue = strValue;
    }
  }
  firstCharGroup.push_back(kg);
  
  initKimarijiInfo();
}
