/*
  HTTPy[Wւ̃ANZXǗ
  Satofumi KAMIMURA
  $Id$
*/

#include "httpAccess.h"
#include "tcpConnect.h"
#include <string.h>


// o^Ă]ׂNA
void HttpAccess::clearData(void) {
  postData = "";
}


// ]ׂǉo^
void HttpAccess::addData(const char *key, const char *value) {
  
  string key_s = key;
  string value_s = value;
  
  postData += ((postData.size() == 0) ? "" : "&") +
    key_s + "=" + value_s;
}


void HttpAccess::addData(const char *key, int value) {
  char buf[13];
  memset(buf, 0, 13);
  sprintf(buf, "%d", value);
  addData(key, buf);
}


void HttpAccess::addData(const char *key, double value) {
  char buf[14];
  memset(buf, 0, 14);
  sprintf(buf, "%.2f", value);
  addData(key, buf);
}


// Mf[^ HTTP wb_菜
static int returnBufferData(TcpConnect& tcp, char *buf, int size,
			    int timeout) {

  int num = tcp.recv(buf, size);
  if (num < 0) {
    return num;
  }
		

  char *body = strstr(buf, "\r\n\r\n") + 4;
  int length = num - (body - buf);
  memmove(buf, body, length);

  return length;
}


// ̓]
int HttpAccess::send(char *buf, int size, int timeout) {
    
  char postCommand[] = "POST %s HTTP/1.0\n"
    "Host: %s\n"
    "Content-Type: application/x-www-form-urlencoded\n"
    "Content-Length: %d\n"
    "\n"
    "%s\n";
  
  char *sendBuf = new char[sizeof(postCommand) + page.size() + host.size() +
			   postData.size() + 3 +1];
  memset(sendBuf, 0, sizeof(sendBuf));
  sprintf(sendBuf, postCommand, page.c_str(), host.c_str(),
	  postData.size(), postData.c_str());

  TcpConnect tcp(host.c_str(), 80);
  tcp.send(sendBuf, strlen(sendBuf));
  delete sendBuf;

  if (!buf) {
    return 0;
  }
  
  return returnBufferData(tcp, buf, size, timeout);
}


int HttpAccess::send(char *buf, int size) {
  return send(buf, size, -1);
}


int HttpAccess::send(int timeout) {
  return send(NULL, 0, timeout);
}


int HttpAccess::send(void) {
  return send(NULL, 0, -1);
}

// ̎M(^CAEg)
int HttpAccess::recv(char *buf, int size, int timeout) {
  char getCommand[] = "GET %s HTTP/1.0\n"
    "Host: %s\n"
    "\n\n";
  
  char *sendBuf = new char[sizeof(getCommand) + page.size() + host.size()];
  memset(sendBuf, 0, sizeof(sendBuf));
  sprintf(sendBuf, getCommand, page.c_str(), host.c_str() +1);
  sendBuf[sizeof(sendBuf)-1] = '\0';
  
  TcpConnect tcp(host.c_str(), 80);
  tcp.send(sendBuf, strlen(sendBuf));
  delete sendBuf;
  
  return returnBufferData(tcp, buf, size, timeout);
}


// ̎M
int HttpAccess::recv(char *buf, int size) {
  return recv(buf, size, -1);
}


// ANZXy[Ww肵ẴIuWFNg
HttpAccess::HttpAccess(const char *url) : initialized(false) {
  
  char *p = strchr(url, '/');
  if (!p) {
    return;
  }
  
  // y[WAzXg̃Zbg
  page = p;
  host.assign(url, p-url);
  postData = "";
}
