/*
  IvV̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include "nettyping.h"
#include "gameOption.h"
#include "convert.h"
#include <fstream>


// f[^̃NA
void GameOption::clearData(void) {
  options.clear();
}


// I𗓂̏
void GameOption::resetTitleSelected(void) {
  selected = 0;
}


// ڂ̒ǉ
void GameOption::addData(gameOption_t *data) {
  options.push_back(*data);

  ++maxSelection;
}


// T[tFX̕`
void GameOption::drawSurface(ScreenCtrl& scr,
			     SDL_Rect *position, FontCtrl& ttf,
			     int selectOffset) {

  SDL_Surface *text;
  SDL_Rect pos = *position;
  int index = 0;
  mTag = NULL;
  for (vector<gameOption_t>::iterator it = options.begin();
       it != options.end(); ++it) {
    pos.x = position->x;

    if (it->titles == NULL) {
      continue;
    }
    text = ttf.createSurface(it->titles[0], MENU_FS, BLACK);
    scr.blitSurface(text, NULL, scr.screen(), &pos);
    SDL_FreeSurface(text);
    
    pos.x = position->x + selectOffset;

    int subIndex = 0;
    for (int i = 1; i < it->max; ++i) {
      text = ttf.createSurface(it->titles[i], MENU_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &pos);

      // J[\̂Ăꍇ
      if ((mx > pos.x) && (mx < pos.x + text->w) &&
	  (my > pos.y) && (my < pos.y + text->h)) {
	mTag = it->tag;
	mSelected = subIndex;
      }
      
      if (subIndex++ == it->selected) {
	SDL_Rect bar;
	bar.x = pos.x;
	bar.y = pos.y + MENU_FS;
	bar.w = text->w;
	bar.h = 5;
	Uint32 color = (index == selected) ? (WHITE | 0xff) : (BLACK);
	scr.fillColor(&bar, color);
      }
      pos.x += text->w + spaceWidth;
      SDL_FreeSurface(text);
    }
    pos.y += MENU_FS + spaceHeight;
    ++index;
  }
}


// I̕ύX
unsigned int GameOption::changeSelect(void) {
  enum { EVENT_MAX = 10, };

  SDL_Event events[EVENT_MAX];
  
  // CxgL[́A}EXړ̃Cxg擾
  SDL_PumpEvents();
  int num = SDL_PeepEvents(events, EVENT_MAX, SDL_PEEKEVENT,
			   SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN) |
			   SDL_EVENTMASK(SDL_MOUSEMOTION) |
			   SDL_EVENTMASK(SDL_KEYDOWN));

  unsigned int retValue = 0;
  SDLKey key;
  SDLMod mod;
  for (int i = 0; i < num; ++i) {
    switch (events[i].type) {
    case SDL_KEYDOWN:
      // J[\͂ɂȈ
      key = events[i].key.keysym.sym;
      mod = events[i].key.keysym.mod;
      if (( key == SDLK_UP ) ||
	  (( key == SDLK_p ) && ( mod & KMOD_CTRL ))) {
	if (selected > 0) {
	  --selected;
	  retValue |= UP_DOWN_CHANGE;
	  
	} else if (selected < 0) {
	  selected = 0;
	  retValue |= UP_DOWN_CHANGE;
	}
	
      } else if (( key == SDLK_DOWN ) ||
		 (( key == SDLK_n ) && ( mod & KMOD_CTRL ))) {
	if (selected < maxSelection -1) {
	  ++selected;
	  retValue |= UP_DOWN_CHANGE;
	}
	
      } else if (( key == SDLK_RIGHT) ||
		 (( key == SDLK_f ) && ( mod & KMOD_CTRL ))) {
	if (options[selected].selected +1 < options[selected].max -1) {
	  ++(options[selected].selected);
	  retValue |= RIGHT_LEFT_CHANGE;
	}
	
      } else if (( key == SDLK_LEFT) ||
		 (( key == SDLK_b ) && ( mod & KMOD_CTRL ))) {
	if (options[selected].selected > 0) {
	  --(options[selected].selected);
	  retValue |= RIGHT_LEFT_CHANGE;
	}
      }
      break;

    case SDL_MOUSEMOTION:
      // }EXʒuXV
      SDL_GetMouseState(&mx, &my);
      break;

    case SDL_MOUSEBUTTONDOWN:
      // I
      if ((SDL_GetMouseState(NULL, NULL) & SDL_BUTTON(1)) &&
	  (mTag != NULL)) {
	// J[\̍ڂI
	setSelected(mTag, mSelected);
	retValue |= UP_DOWN_CHANGE;
      }
      break;
    }
  }
  
  return retValue;
}


// c󔒂̐ݒ
void GameOption::setSpaceHeight(int height) {
  spaceHeight = height;
}


// 󔒂̐ݒ
void GameOption::setSpaceWidth(int width) {
  spaceWidth = width;
}


// ڏ̎o
int GameOption::getSelected(const char *tag) {

  for (vector<gameOption_t>::iterator it = options.begin();
       it != options.end(); ++it) {
    if (!strcmp(tag, it->tag)) {
      return it->selected;
    }
  }
  return -1;
}


void GameOption::setSelected(const char *tag, int value) {
  for (vector<gameOption_t>::iterator it = options.begin();
       it != options.end(); ++it) {
    if (!strcmp(tag, it->tag)) {
      it->selected = value;
    }
  }  
}


// IvV̓ǂݏo
void GameOption::loadOption(void) {

  std::ifstream fd(fileName);
  if (!fd) {
    fprintf(stderr, "Notice: %s is not found.\n", fileName);
    return;
  }

  char buf[BUFSIZ];

  // \̂̏At@Cɂɂď㏑  
  while (!fd.eof()) {
    fd.getline(buf, BUFSIZ);

    for (vector<gameOption_t>::iterator it = options.begin();
	 it != options.end(); ++it) {
      unsigned int length = strlen(it->tag);
      if (!strncmp(buf, it->tag, length) && (strlen(buf) > length +1)) {
	it->selected = atoi(&buf[length + 1]);
      }
    }
  }
}


// IvV̕ۑ
void GameOption::saveOption(void) {

  std::ofstream fd(fileName);
  if (!fd) {
    perror("option saved");
  }
  
  // ^Otɂăt@Co
  for (vector<gameOption_t>::iterator it = options.begin();
       it != options.end(); ++it) {
    fd << it->tag << ", " << it->selected << endl;
  }
}


// t@Cw̃RXgN^
GameOption::GameOption(const char *fname) :
  fileName(fname), spaceHeight(0), spaceWidth(MENU_FS), selected(0),
  maxSelection(0), mTag(NULL) {

  clearData();
  SDL_GetMouseState(&mx, &my);
}


GameOption::~GameOption(void) {
  saveOption();
}
