/*
  ̤Ѥؿ
  Satofumi KAMIMURA
  $Id$
*/

#include "nettyping.h"
#include "drawUtils.h"


// ץνλ
void gameExit(void) {
  exit(0);
}


// ȥɽ
bool waitFirstMusicEnd(int msec, ScreenCtrl& scr,
		       FontCtrl& ttf, SoundCtrl& snd, Timer& soundTimer,
		       Uint16 titleTTF[]) {
  
  scr.fillBack();
  
  // ȥɽ
  SDL_Rect pos;
  pos.x = scr.w()/2;
  pos.y = scr.h()/2;
  SDL_Surface *title =
    ttf.createSurface(titleTTF, MENU_FS, BLACK);
  scr.blitSurface(title, NULL, scr.screen(), &pos, CENTER | BOTTOM);
  SDL_FreeSurface(title);

  while (!soundTimer.isOver(msec)) {
    snd.update();
    scr.update();
    scr.frameRateWait();
    userInput_t ui = scr.eventHandler();
    if (ui.quit) {
      gameExit();
    } else if (ui.escape) {
      snd.playMusic(-1);
      snd.playEffect(-1);
      return false;
    }
  }
  return true;
}


// 
void drawInputArea(ScreenCtrl& scr, FontCtrl& ttf,
		   const SDL_Rect *position, Convert& cnv, int mode) {
  enum {
    BORDER_WIDTH = 5,
  };
    
  // Ȥ
  SDL_Rect out = *position;
  out.x -= BORDER_WIDTH;
  out.y -= BORDER_WIDTH;
  out.w += BORDER_WIDTH * 2;
  out.h += BORDER_WIDTH * 2;
  if (mode == CLEAR) {
    scr.fillBack(&out);
    return;
  }
  scr.fillColor(&out, BLACK);

  // ʸ
  Uint16 *buffer = cnv.getConvertBuffer();
  SDL_Surface *text = ttf.createSurface(buffer, TYPE_FS, WHITE, BLACK | 0xff);
  SDL_Rect pos = *position;
  if (text) {
    scr.blitSurface(text, NULL, scr.screen(), &pos);
    pos.x += text->w;
  }
  SDL_FreeSurface(text);

  // ɽ
  pos.y += TYPE_FS - 6;
  pos.w = TYPE_FS/2;
  pos.h = 3;
  scr.fillColor(&pos, WHITE | 0xff);
}


// ϴλοɽ
void drawTotalWakaTyped(ScreenCtrl& scr, FontCtrl& ttf,
			int num, int all) {
  char char_str[9];
  Uint16 str[8] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

  sprintf(char_str, "%2d/%d\n", num, all);
  for (int i = 0; char_str[i] != '\n'; ++i) {
    str[i] = char_str[i];
  }
  SDL_Surface *text = ttf.createSurface(str, TYPE_FS, BLACK);

  SDL_Rect pos;
  pos.x = scr.w();
  pos.y = 0;
  scr.blitSurface(text, NULL, scr.screen(), &pos, RIGHT | TOP);
  SDL_FreeSurface(text);
}


// ̹ܤɽ
void drawResultText(ScreenCtrl& scr, FontCtrl& ttf,
		    Uint16 name[], char char_str[], Uint16 tani[],
		    SDL_Rect *namePos, SDL_Rect *resultPos) {
  
  SDL_Surface *text;

  // ܤɽ
  if (name) {
    text = ttf.createSurface(name, RESULT_FS, BLACK);
    scr.blitSurface(text, NULL, scr.screen(), namePos, BOTTOM);
    SDL_FreeSurface(text);
  }

  // ɽ
  Uint16 str[15];
  Uint16 *up = str;
  char *cp = char_str;
  while ((*(up++) = *(cp++)) != 0x00)
    ;
  text = ttf.createSurface(str, RESULT_FS, BLACK);
  scr.blitSurface(text, NULL, scr.screen(), resultPos, RIGHT | BOTTOM);
  SDL_FreeSurface(text);

  // ñ̤ɽ
  text = ttf.createSurface(tani, RUBI_FS, BLACK);
  scr.blitSurface(text, NULL, scr.screen(), resultPos, LEFT | BOTTOM);
  SDL_FreeSurface(text);
}


// Ф褦ɽ
void learnMode(ScreenCtrl& scr, FontCtrl& ttf, SoundCtrl& snd,
	       WakaResource& waka, int ids[], int max) {
  
  scr.fillBack();

  wakaResource_t wr;
  SDL_Surface *ku;
  SDL_Rect pos;
  pos.y = 0;
  
  for (int j = 0; j < max; ++j) {
    pos.y += LEARN_FS;
    pos.x = LEARN_FS/4*3;
    wr = waka.getWakaData(ids[j]);
    for (int i = 0; i < 5; ++i) {
      if (i == 3) {
	pos.x = LEARN_FS * 2;
	pos.y += LEARN_FS/2 * 3;
      }
      ku = ttf.createSurface(wr.yomi[i], LEARN_FS, BLACK);
      scr.blitSurface(ku, NULL, scr.screen(), &pos);
      pos.x += ku->w + LEARN_FS/4*3;
      SDL_FreeSurface(ku);
    }
    pos.y += LEARN_FS/2*3;
  }

  scr.initFrameRateCtrl();
  while (1) {
    scr.update();
    userInput_t ui = scr.eventHandler();
    if (ui.quit) {
      gameExit();
      
    } else if (ui.enter || ui.leftclick || ui.escape) {
      snd.playEffect(DECIDE_EFFECT);
      return;
    }
  }
}
