/*
  [}Eȕϊ̏
  Satofumi KAMIMURA
  $Id$
*/

#include "convert.h"
#include "romanConvertTbl.h"	// [}ȕϊe[u
#include "kanaConvertTbl.h"	// ȕϊe[u
#include <string.h>


// ϊ̃obt@f[^Ԃ
Uint16 *Convert::getConvertBuffer(void) {
  return convertBuffer;
}


// ͂Pǉ
void Convert::addChar(char key) {

  // obt@ς̏ꍇ͖
  if ( lastPosition >= (CONVERT_BUFFER_SIZE -1) ) {
    return;
  }

  convertBuffer[lastPosition++] = key;
  convert();
  if ((key == '\n') && (convertBuffer[lastPosition -1] == '\n')) {
    deleteLast();
  }
}


// ̂P폜
void Convert::deleteLast(void) {

  // obt@̏ꍇ͖
  if ( lastPosition <= 0 ) {
    return;
  }
  convertBuffer[--lastPosition] = 0x00;
}


// ϊ̃obt@NA
void Convert::clearBuffer(void) {

  memset(convertBuffer, 0x00, CONVERT_BUFFER_SIZE+1);
  lastPosition = 0;
}


static int getBufferLength(const Uint16 buffer[]) {
  int length = 0;
  while (buffer[length] != 0x00) {
    ++length;
  }
  return length;
}


// obt@̕Ԃ
int Convert::getBufLen(void) {
  return lastPosition;
}


// }b`ϊ̒u
void Convert::matchedReplace(int pos_index, int length, int tbl_index) {

  // u镶̒擾
  int replace_size = getBufferLength(&convertTbl[2*TBL_PTN_SIZE * tbl_index
						 + TBL_PTN_SIZE]);

  // 炷̒vZ
  int move_length = (replace_size > length)
    ? (CONVERT_BUFFER_SIZE - (pos_index + length))
    : (lastPosition - (pos_index + length));
  
  // 㔼̕炷
  memmove(&convertBuffer[pos_index + replace_size],
	  &convertBuffer[pos_index + length], move_length);
  lastPosition += replace_size - length;

  // obt@I[ɂ 0x00 ߂
  for (int i = lastPosition; i < CONVERT_BUFFER_SIZE; ++i) {
    convertBuffer[i] = 0x00;
  }

  // }b`̒u
  for (int i = 0; i < replace_size; ++i) {
    convertBuffer[pos_index + i] = convertTbl[2*TBL_PTN_SIZE * tbl_index
					      + TBL_PTN_SIZE + i];
  }
}


// ȕϊ̏
void Convert::convert(void) {

  // ϊꏊύX郋[v
  for (int pos_index = 0; pos_index <= lastPosition; ++pos_index) {
  
    // e[uT郋[v
    for (int tbl_index = 0; convertTbl[2*TBL_PTN_SIZE * tbl_index]
	   != 0x00; ++tbl_index) {

      // ̃}b`O郋[v
      int length = 0;
      int tbl_pos = 2 * TBL_PTN_SIZE * tbl_index;
      while (( convertTbl[tbl_pos + length] != 0x00 ) && 
	     ( convertTbl[tbl_pos + length]
	       == convertBuffer[pos_index + length] )) {
	++length;
      }
      if (( length != 0 ) && ( convertTbl[tbl_pos + length] == 0x00 )) {
	// p^[ɃqbgAu
	matchedReplace(pos_index, length, tbl_index);
      }
    }
  }
}


void Convert::init(int convertType) {
  clearBuffer();
  if (convertType == ROMAN_CONVERT) { // [}ϊe[uݒ
    convertTbl = &RomanTbl[0][0];
  } else if (convertType == KANA_CONVERT) { // ȕϊe[uݒ
    convertTbl = &KanaTbl[0][0];
  }
}


Convert::Convert(int convertType) {
  init( convertType );
}


Convert::Convert(void) {
  init( ROMAN_CONVERT );
}
