/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;

import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.preference.SnmpV3Preference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;



/**
 * SNMP V3 TrapMsNXłB
 * MTrapf[^͂ǗΏۂ̃`FbNAf[^̐
 * `FbNāAÓłTrapMXi[ɓo^Ă鏈
 * s܂B
 *
 * SNMP V3 TrapMf[^tH[}bg͈ȉ̒ʂłB
 *
 * +-----------+-----------+----------------------------+
 * | Header    |           | msgVersion                 |
 * |           |           +----------------------------+
 * |           |           | msgID                      |
 * |           |           +----------------------------+
 * |           |           | msgMaxSize                 |
 * |           |           +----------------------------+
 * |           |           | msgFlags                   |
 * |           |           +----------------------------+
 * |           |           | msgSecurityModel           |
 * +-----------+-----------+----------------------------+
 * | Security  |           | msgAuthoritativeEngineID   |
 * | Params    |           +----------------------------+
 * |           |           | msgAuthoritativeBoots      |
 * |           |           +----------------------------+
 * |           |           | msgAuthoritativeEngineTime |
 * |           |           +----------------------------+
 * |           |           | msgUserName                |
 * |           |           +----------------------------+
 * |           |           | msgAuthenticationParameters|
 * |           |           +----------------------------+
 * |           |           | msgPrivacyParameters       |
 * +-----------+-----------+----------------------------+
 * | Scoped    |           | contextEngineID            |
 * | PDU Data  |           +----------------------------+
 * |           |           | contextName                |
 * |           |           +----------------------------+
 * |           |           | PDU Data                   |
 * +-----------+-----------+----------------------------+
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapV3ReceiveMP extends AbstractTrapMessageProcessing {
    // SNMP V3 AgentǗ
    private SnmpV3ManagerConfigInfo snmpConfigInformation = null;

    // Message HeaderGA
    private AbstractSnmpObject msgVersion;
    private AbstractSnmpObject msgID;
    private AbstractSnmpObject msgMaxSixe;
    private AbstractSnmpObject msgFlags;
    private AbstractSnmpObject msgSecurityModel;

    // Message Security ParamsGA
    private AbstractSnmpObject msgAuthoritativeEngineID;
    private AbstractSnmpObject msgAuthoritativeBoots;
    private AbstractSnmpObject msgAuthoritativeEngineTime;
    private AbstractSnmpObject msgUserName;

    /* contextEngineID */
    private AbstractSnmpObject contextEngineID;

    /* contextName */
    private AbstractSnmpObject contextName;

    /* MSNMP EngineID */
    private String snmpEngineID = "";

    /* MSNMP EngineBoots */
    private int snmpEngineBoots = 0;

    /* MSNMP User Name */
    private String userName = "";

    /* MSNMP AuthPriv */
    private String authPriv = "";

    /* MSNMP msgFlags */
    private int receiveMsgFlags = 0;

    /* MSNMP Security Model */
    private int receiveSecurityModel = 0;

    /* MO */
    private Logger logger;

    /**
     * Snmp V3 TrapMCX^X𐶐܂B
     *
     */
    public TrapV3ReceiveMP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Snmp TrapMłdisptcherSnmp V3̏ꍇɋNA
     * Mf[^͂ATrapMXi[o^ꂢ郊Xg
     * Xi[ǂݏoAtrapMƂẴe[u\Ȃǂs܂B
     *
     * Mf[^͂ɂẮAEngineIDAUsero^ǗΏۂł邩
     * `FbNAǗΏۊO͗OX[܂B
     *
     * @param agentAddress AgentAhX
     * @param encodedMessage Mf[^
     * @param listenerList Xi[o^List
     * @throws SnmpV3ConfigurationException SNMP V3\`Ɉُ킪ꍇ
     * @throws GeneralSecurityException ZLeBňُ킪ꍇ
     * @throws SnmpBadValueException MTrapǗΏۊȌꍇ
     * @throws SnmpV3DecryptAbortException f[^Ɉُ킪ꍇ
     */
    public void process(
        final String agentAddress, final byte[] encodedMessage,
        final List listenerList)
        throws SnmpV3ConfigurationException, GeneralSecurityException,
            SnmpBadValueException, SnmpV3DecryptAbortException {
        /* USM(User based Security Model) UserGg[ */
        UsmUserEntry usmUserEntry = null;

        /* pPbg̃fR[h */
        SnmpSequence request = new SnmpSequence();
        SNMPTLV nextTLV2 = request.extractNextTLV(encodedMessage, 0);
        request.setTLV(nextTLV2);

        /* SNMP̃o[WoE`FbN */
        msgVersion =
            request.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_VERSION);

        if (!(msgVersion instanceof SnmpInteger)) {
            logger.warning("Version is not INTEGER : " + msgVersion.toString());
            throw new SnmpBadValueException(
                "Version is not INTEGER : " + msgVersion.toString());
        }

        /*
         * Header
         */
        parseHeader(request);

        /*
         * SNMP V3 TrapbZ[WSecurity Params
         */
        SnmpSequence securityParamsSequence = parseSecurityParams(request);

        /*
         * msgAuthenticationParameters
         */
        AbstractSnmpObject msgAuthenticationParameters =
            parseMsgAuthenticationParameters(securityParamsSequence);

        /*
         * msgPrivacyParameters
         */
        AbstractSnmpObject msgPrivacyParameters =
            parseMsgPrivacyParameters(securityParamsSequence);

        /*
         * SNMP V3 TrapbZ[W̃p[^`FbN
         * snmpEngineIDo^ς݂`FbN
         * (MsnmpEngineID"0x"č\)
         */
        snmpEngineID =
            msgAuthoritativeEngineID.toString().substring("0x".length());

        HashMap snmpV3EngineIDList =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigEngineIDMapList();

        if ((snmpV3EngineIDList != null) && (snmpV3EngineIDList.size() > 0)) {
            snmpConfigInformation =
                (SnmpV3ManagerConfigInfo) snmpV3EngineIDList.get(snmpEngineID);
        }

        if (snmpConfigInformation != null) {
            /*
            * MsnmpEngineIDo^񂪊ǗΏ
            * G[WFg
            */
            logger.info(
                "Trap agnet IP Address : "
                + snmpConfigInformation.getIpAddress());
            logger.info(
                "User Name : "
                + ((SnmpV3ManagerUserConfigInfo) snmpConfigInformation.getUserList()
                                                                      .get(0))
                .getUsername());
        } else {
            /*
            * MsnmpEngineIDo^񂩂猩Ȃ
            * ꍇ
            * ǗΏۃG[WFgł邪wK̏ꍇz肵A
            * G[WFgAhXǗΏۉ`FbN
            */
            detectNoRegisterAgent(agentAddress);
        }

        // userNameo^ς݂
        userName =
            ((SnmpV3ManagerUserConfigInfo) snmpConfigInformation.getUserList()
                                                                .get(0))
            .getUsername();

        if (!(userName.equals(msgUserName.toString()))) {
            logger.warning("Not found UserName : " + msgUserName);
        }

        // ZLeBtO͈v邩
        authPriv =
            ((SnmpV3ManagerUserConfigInfo) snmpConfigInformation.getUserList()
                                                                .get(0))
            .getAuthPriv();

        logger.info("authPriv : " + authPriv);
        logger.info("msgFlags : " + msgFlags);

        // ZLeBf`FbN
        logger.info("msgSecurityModel : " + msgSecurityModel);

        try {
            receiveMsgFlags = Integer.parseInt(msgFlags.toString());
        } catch (NumberFormatException e3) {
            logger.warning("Illegal msgFlags : " + receiveMsgFlags);
        }

        // ReporttO}XNAAuth/PrivtO bito
        receiveMsgFlags =
            receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT_MASK;

        // NOAUTH/AUTH/PRIV
        if (authPriv.equals(SnmpV3Preference.NOAUTH)) {
            if (receiveMsgFlags != SnmpV3Preference.SNMPV3_MSG_FLAGS_NOAUTH) {
                logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
            }
        } else if (authPriv.equals(SnmpV3Preference.AUTH)) {
            if (receiveMsgFlags != SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) {
                logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
            }
        } else if (authPriv.equals(SnmpV3Preference.PRIV)) {
            if (receiveMsgFlags != SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH_PRIV) {
                logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
            }
        }

        try {
            receiveSecurityModel =
                Integer.parseInt(msgSecurityModel.toString());

            if (!(receiveSecurityModel == SnmpV3Preference.SECURITY_MODEL_USM)) {
                logger.warning(
                    "Unmuch msgSecurityModel : " + receiveSecurityModel);
            }
        } catch (NumberFormatException e2) {
            /* Snmp V3 SecurityModeltH[}bgُ */
            logger.warning(
                "Illegal msgSecurityModel : " + receiveSecurityModel);
            throw new SnmpBadValueException(
                "Illegal msgSecurityModel : " + receiveSecurityModel);
        }

        /*
         * SNMP V3 msgFlagɂAuth Flag(F)`FbN
         */
        if (
            (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) == SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) {
            /*
             * F؂͐邩F؃`FbN
             *
             */
            usmUserEntry = checkAuth(request, securityParamsSequence);
        }

        /* Scoped PDU */
        SnmpSequence scopedPDUData = null;

        snmpEngineBoots = Integer.parseInt(msgAuthoritativeBoots.toString());

        if (
            request.getSNMPObjectAt(SnmpV3Preference.POS_SCOPED_PDU_DATA) instanceof SnmpOctetString) {
            /* SNMP V3 msgFlagɂPriv Flag`FbN */
            if (
                (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) == SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) {
                scopedPDUData =
                    decryptScopedPDU(
                        request, usmUserEntry, msgPrivacyParameters);
            } else {
                /*
                 * msgFlagsprivwłȂꍇ́ASequenceMƂȂ͂A
                 * OctetStringM̂߂Ɉُf[^Ɣf
                 */
                logger.warning("Receive scopedPDU Data format error");
            }
        } else {
            /* Scoped PDUo */
            scopedPDUData =
                (SnmpSequence) request.getSNMPObjectAt(
                    SnmpV3Preference.POS_SCOPED_PDU_DATA);
        }

        if (scopedPDUData == null) {
            logger.warning("Receive ScopedPDU Data nul");

            return;
        }

        /* Scoped PDU */
        parseScopedPDUData(scopedPDUData, listenerList);
    }

    /**
     * MsnmpEngineIDo^񂩂猩Ȃꍇ
     * ǗΏۃG[WFgł邪wK̏ꍇz肵A
     * G[WFgAhXǗΏۉ`FbN܂B
     *
     * @param agentAddress AgentAhX
     * @throws SnmpV3ConfigurationException MTrap
     * AgentAhXo^̏ꍇ
     */
    private void detectNoRegisterAgent(String agentAddress)
        throws SnmpV3ConfigurationException {
        /*
         * MsnmpEngineIDo^񂩂猩Ȃ
         * ꍇ
         * ǗΏۃG[WFgł邪wK̏ꍇz肵A
         * G[WFgAhXǗΏۉ`FbN
         */
        snmpConfigInformation =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(agentAddress);

        if ((snmpConfigInformation == null) && agentAddress.equals("localhost")) {
            /* ǗΏۃG[WFgł邪wK̏ꍇ
                 * Ao^AgentƂČȂꍇɂ
                 * ēxAlocalhostf[^Ɣr
                 */
            snmpConfigInformation =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3AgentInfo("127.0.0.1");
        }

        if (snmpConfigInformation == null) {
            /*
             * TrapMo^Agent̂߂ɗOX[
             * ďf
             */
            logger.warning("Not found Agent address : " + agentAddress);
            throw new SnmpV3ConfigurationException(
                "Not found Snmp V3 agent address : " + agentAddress);
        }

        /*
         * wKAgentiAgentƂĂ͊ǗΏہjTrap
         * M
         */
        snmpConfigInformation.setSnmpEngineID(snmpEngineID);
        logger.warning("No discovery agent register : " + agentAddress);

        /*
         * snmpEngineIDUSMXgAUSM[U}l[Wɓo^
         */
        SnmpEngineID registerSnmpEngineID = new SnmpEngineID(snmpEngineID);
        logger.info("SnmpEngineID : " + snmpEngineID);

        try {
            UsmUserManager.getInstance().registList(
                registerSnmpEngineID, snmpConfigInformation);
        } catch (SnmpV3ConfigurationException e1) {
            /* USMo^s */
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        /*
         * SNMP V3 TrapMɂF؁EASY
         */
        try {
            MessageDigest.getInstance(SnmpV3Preference.AUTH_PROTOCOL_MD5);
            MessageDigest.getInstance(SnmpV3Preference.AUTH_PROTOCOL_SHA1);
            Mac.getInstance(SnmpV3Preference.HMAC_MD5);
            Mac.getInstance(SnmpV3Preference.HMAC_SHA1);
            Cipher.getInstance(SnmpV3Preference.PRIV_PROTOCOL_DES);
            SecretKeyFactory.getInstance(SnmpV3Preference.PRIV_PROTOCOL_DES);
        } catch (Throwable e) {
            /*
             * Snmp V3łUSM[U}l[Wɓo^ɂāA
             * F/Íx`́AASY
             * `̏ꍇ
             */
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    /**
     * TrapMf[^̔F؃`FbNs܂B
     * AF؂łȂꍇłG[́AɕsAgentTrap
     * Ƃďp܂B
     *
     * @param request MSNMP Sequence
     * @param securityParamsSequence Security Params SNMP Sequence
     * @return usmUserEntry USM User Entry
     * @throws GeneralSecurityException
     */
    private UsmUserEntry checkAuth(
        final SnmpSequence request, final SnmpSequence securityParamsSequence)
        throws GeneralSecurityException {
        /*
         * F؂͐邩F؃`FbN
         *
         */
        boolean isCheckAuth = false;
        UsmUserEntry usmUserEntry =
            UsmUserManager.getInstance().getUsmUserEntry(
                new SnmpEngineID(snmpEngineID), userName);

        logger.info("SNMP V3 Trap receive SnmpEngineID : " + snmpEngineID);
        logger.info("SNMP V3 Trap receive UserName : " + userName);

        if (usmUserEntry == null) {
            logger.warning("SNMP V3 Trap receive not user entry");
            logger.warning(
                "SNMP V3 Trap receive  snmpEngineID : " + snmpEngineID);
            logger.warning("NMP V3 Trap receive userName : " + userName);
        } else {
            logger.info(
                "usmUserEntry.usmUserSecurityName : "
                + usmUserEntry.getUsmUserSecurityName());
            logger.info(
                "usmUserEntry.usmUserName : " + usmUserEntry.getUsmUserName());

            try {
                isCheckAuth =
                    UsmSecuritySubsystem.getInstance().checkAuth(
                        request, securityParamsSequence,
                        usmUserEntry.getUsmUserAuthKey());
            } catch (GeneralSecurityException e4) {
                /* F؂ňُ팟o */
                logger.warning(e4.getMessage());
                e4.printStackTrace();
                throw e4;
            }
        }

        if (isCheckAuth) {
            logger.info("isCheckAuth true : " + isCheckAuth);
        } else {
            /* sAgentSNMP V3 TrapM */
            logger.warning("Auth check error");
            logger.warning(
                "SNMP V3 Trap receive  snmpEngineID : " + snmpEngineID);
            logger.warning("NMP V3 Trap receive userName : " + userName);

            // return;
        }

        return usmUserEntry;
    }

    /**
     * SNMP V3 TrapbZ[WHeader
     *
     * @param request MTrap SNMP Sequencef[^
     */
    private void parseHeader(final SnmpSequence request) {
        /* SNMP V3 TrapbZ[WHeader */
        SnmpSequence header =
            (SnmpSequence) request.getSNMPObjectAt(
                SnmpV3Preference.POS_HEADER_OF_MESSAGE);
        msgID = header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_ID);
        msgMaxSixe =
            header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_MAXSIZE);
        msgFlags = header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_FLAGS);
        msgSecurityModel =
            header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_SEC_MODEL);

        /*
         * Loggingyуj^[\
         */
        logger.info("msgVersion : " + msgVersion.getValue());
        logger.info("msgID : " + msgID.getValue());
        logger.info("msgMaxSixe : " + msgMaxSixe.getValue());
        logger.info("msgFlags : " + msgFlags);
        logger.info("msgSecurityModel : " + msgSecurityModel.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgVersion : " + msgVersion.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgID : " + msgID.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgMaxSixe : " + msgMaxSixe.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgFlags : " + msgFlags);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgSecurityModel : " + msgSecurityModel.getValue());
    }

    /**
     * SNMP V3 TrapbZ[W Security Params
     *
     * @param request MTrap SNMP Sequencef[^
     * @return securityParamsSequence securityParamsSequence
     * @throws SnmpBadValueException Mf[^͂Ɏsꍇ
     */
    private SnmpSequence parseSecurityParams(final SnmpSequence request)
        throws SnmpBadValueException {
        SnmpOctetString securityParaOctet =
            (SnmpOctetString) request.getSNMPObjectAt(
                SnmpV3Preference.POS_SECURITY_PARA_MESSAGE);
        SnmpSequence securityPara = null;
        securityPara = new SnmpSequence((byte[]) securityParaOctet.getValue());

        SnmpSequence securityParamsSequence =
            (SnmpSequence) securityPara.getSNMPObjectAt(0);
        msgAuthoritativeEngineID =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINEID);
        msgAuthoritativeBoots =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINEBOOTS);
        msgAuthoritativeEngineTime =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINETIME);
        msgUserName =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_USERNAME);

        /*
         * Loggingyуj^[\
         */
        logger.info("msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        logger.info(
            "msgAuthoritativeBoots : " + msgAuthoritativeBoots.getValue());
        logger.info(
            "msgAuthoritativeEngineTime : "
            + msgAuthoritativeEngineTime.getValue());
        System.out.println("msgUserName : " + msgUserName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgAuthoritativeBoots : " + msgAuthoritativeBoots.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "msgAuthoritativeEngineTime : "
            + msgAuthoritativeEngineTime.getValue());

        return securityParamsSequence;
    }

    /**
     * SNMP V3 TrapbZ[W msgAuthenticationParameters
     *
     * @param securityParamsSequence securityParamsSequence
     * @return msgAuthenticationParameters msgAuthenticationParameters
     */
    private AbstractSnmpObject parseMsgAuthenticationParameters(
        final SnmpSequence securityParamsSequence) {
        AbstractSnmpObject msgAuthenticationParameters =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_PARAMS);

        try {
            byte[] msgAuthenticationParametersCode =
                (byte[]) msgAuthenticationParameters.getValue();
            logger.info(
                "msgAuthenticationParameters : "
                + hexBytetoString(
                    msgAuthenticationParametersCode,
                    msgAuthenticationParametersCode.length));
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                "msgAuthenticationParameters : length = "
                + msgAuthenticationParametersCode.length);
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                hexBytetoString(
                    msgAuthenticationParametersCode,
                    msgAuthenticationParametersCode.length));
        } catch (Exception e) {
            logger.warning("Logging/Monitor abort : " + e.getMessage());
        }

        return msgAuthenticationParameters;
    }

    /**
     * SNMP V3 TrapbZ[W msgPrivacyParameters
     *
     * @param securityParamsSequence securityParamsSequence
     * @return msgPrivacyParameters msgPrivacyParameters
     */
    private AbstractSnmpObject parseMsgPrivacyParameters(
        final SnmpSequence securityParamsSequence) {
        AbstractSnmpObject msgPrivacyParameters =
            securityParamsSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_PRIV_PARAMS);

        try {
            logger.info(
                "msgPrivacyParameters : "
                + hexBytetoString(
                    (byte[]) msgPrivacyParameters.getValue(),
                    ((byte[]) msgPrivacyParameters.getValue()).length));
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                "msgPrivacyParameters : length = "
                + ((byte[]) msgPrivacyParameters.getValue()).length);
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                hexBytetoString(
                    (byte[]) msgPrivacyParameters.getValue(),
                    ((byte[]) msgPrivacyParameters.getValue()).length));
        } catch (Exception e) {
            logger.warning("Logging/Monitor abort : " + e.getMessage());
        }

        return msgPrivacyParameters;
    }

    /**
     * TrapMf[^𕜍Scoped PDU𐶐܂B
     *
     * @param request MTrap SNMP Sequencef[^
     * @param usmUserEntry USM(User based Security Model)Gg
     * @param msgPrivacyParameters MTrap  msgPrivacyParameters
     * @return@scopedPDUData ScopedPDU
     * @throws SnmpV3DecryptAbortException ňُoꍇ
     * @throws GeneralSecurityException ZLeBɈُ킪ꍇ
     */
    private SnmpSequence decryptScopedPDU(
        final SnmpSequence request, final UsmUserEntry usmUserEntry,
        final AbstractSnmpObject msgPrivacyParameters)
        throws SnmpV3DecryptAbortException, GeneralSecurityException {
        SnmpSequence scopedPDUData = null;

        /* msgFlags privw */
        SnmpOctetString scopedPDUOctet =
            (SnmpOctetString) request.getSNMPObjectAt(
                SnmpV3Preference.POS_SCOPED_PDU_DATA);

        try {
            System.out.println(
                "usmUserEntry.usmUserSecurityName : "
                + usmUserEntry.getUsmUserSecurityName());
            System.out.println(
                "usmUserEntry.usmUserName : " + usmUserEntry.getUsmUserName());
            System.out.println(
                "usmUserEntry.usmUserPrivProtocol : "
                + usmUserEntry.getUsmUserPrivProtocol());
            System.out.println(
                "usmUserEntry.usmUserPrivKey.getAlgorithm : "
                + usmUserEntry.getUsmUserPrivKey().getAlgorithm());

            /* scopedPDU */
            SnmpSequence scopedPDUDataWork =
                UsmSecuritySubsystem.getInstance().decrypt(
                    (byte[]) scopedPDUOctet.getValue(),
                    (byte[]) msgPrivacyParameters.getValue(),
                    usmUserEntry.getUsmUserPrivKey());

            if (scopedPDUDataWork == null) {
                logger.warning("Abort decrypt scopedPDU of trap receive");
                throw new SnmpV3DecryptAbortException(
                    "Abort decrypt scopedPDU of trap receive");
            }

            scopedPDUData = (SnmpSequence) scopedPDUDataWork.getSNMPObjectAt(0);
        } catch (GeneralSecurityException e4) {
            logger.warning(e4.getMessage());
            e4.printStackTrace();
            throw e4;
        }

        return scopedPDUData;
    }

    /**
     * Scopde PDU͂܂B
     * TrapMXi[o^Ă郊Xg烊Xi[Ɏ
     * TrapMs܂B
     *
     * @param scopedPDUData Scopde PDU
     * @param listenerList TrapMXi[List
     */
    private void parseScopedPDUData(
        final SnmpSequence scopedPDUData, final List listenerList)
        throws SnmpBadValueException {
        logger.info(
            "Scoped PDU Data : length = "
            + scopedPDUData.getBEREncoding().length);
        logger.info(
            hexBytetoString(
                scopedPDUData.getBEREncoding(),
                scopedPDUData.getBEREncoding().length));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Scoped PDU Data : length = "
            + scopedPDUData.getBEREncoding().length);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            hexBytetoString(
                scopedPDUData.getBEREncoding(),
                scopedPDUData.getBEREncoding().length));

        /*
         * SNMP V3 TrapbZ[WscopedPDU
         * EcontextEngineIDo
         * EcontextNameo
         */
        contextEngineID =
            scopedPDUData.getSNMPObjectAt(
                SnmpV3Preference.SCOPED_PDU_CONTEXT_ENGINEID);
        contextName =
            scopedPDUData.getSNMPObjectAt(
                SnmpV3Preference.SCOPED_PDU_CONTEXT_NAME);

        /* PDU Data */
        AbstractSnmpObject pduData =
            scopedPDUData.getSNMPObjectAt(SnmpV3Preference.SCOPED_PDU_PDU_DATA);

        /* Logging/Monitor set */
        logger.info("contextName : " + contextName);
        logger.info("contextEngineID : " + contextEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "contextName : " + contextName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "contextEngineID : " + contextEngineID);

        /* PDUf[^ */
        SnmpTrap2PDU trap2PDU = this.parseSNMPTrap2PDU(pduData);

        // pass the received trap PDU to the processTrap method of any listeners

        /*
         * TrapMXi[o^Ă郊Xg烊Xi[
         * ǂݏoAΉ鏈s
         *
         */
        for (int i = 0; i < listenerList.size(); i++) {
            ITrapListener listener = (ITrapListener) listenerList.get(i);

            /* Xi[ɎĂTrapMs */
            listener.processTrapV2(
                trap2PDU, SnmpPreference.SNMPV3_DESCRIPTION,
                snmpConfigInformation.getIpAddress());
        }
    }
}
