/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.application.NetJFWatcherApplication;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;



/**
 * SNMP}l[W OIDe[uIXi[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class OidTableListener extends SelectionAdapter {
    /* OIDe[u */
    private final Table managerOidTable;

    /* Manager OIDe[ȗIOID Description */
    private String selectOidDescription;

    /* Manager OIDe[ȗIOID */
    private String selectOid;

    /* Manager OIDe[ȗIOID̒l */
    private String selectValue;

    /* Manager OIDe[ȗIOIDType */
    private String selectType;

    /* Manager OIDe[ȗIOIDAccess */
    private String selectAccess;

    /**
     * SNMP}l[W CX^Xe[uXi[NX
     * CX^X𐶐܂B
     *
     * @param table Table
     */
    public OidTableListener(Table table) {
        this.managerOidTable = table;
    }

    /**
     * TableIłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        /* e[uIs(Row)o */
        int index = managerOidTable.getSelectionIndex();

        if (index == -1) {
            return;
        }

        // TablȇI͈͂
        // table.setSelection(new int[0]);
        // Iꂽs(Row)TableItem擾
        TableItem item = managerOidTable.getItem(index);
        selectOidDescription = item.getText(OidTableViewLabelProvider.OID_DESC);
        selectOid = item.getText(OidTableViewLabelProvider.OID);
        selectValue = item.getText(OidTableViewLabelProvider.VALUE);
        selectType = item.getText(OidTableViewLabelProvider.TYPE);
        selectAccess = item.getText(OidTableViewLabelProvider.ACCESS);

        updateManagerOperationView();
    }

    /*
     * OIDe[uőIꂽOID𑀍r[ɃZbg܂B
     *
     */
    private void updateManagerOperationView() {
        /*
         * OID TreeőIꂽOIDSNMP V1/V2C/V3 }l[WView
         * OID̓eLXgɃZbg
         */
        NetJFWatcherApplication.getSnmpV1OperationView().getOidText().setText(
            selectOid);
        NetJFWatcherApplication.getSnmpV2OperationView().getOidText().setText(
            selectOid);
        NetJFWatcherApplication.getSnmpV3OperationView().getOidText().setText(
            selectOid);

        /*
         * OID TreeőIꂽOIDTypeSNMP}l[WView
         * łTypeIComboBoxɃZbg
         */
        NetJFWatcherApplication.getSnmpV1OperationView().getSnmpValueTypeCombo()
                       .setText(selectType);
        NetJFWatcherApplication.getSnmpV2OperationView().getSnmpValueTypeCombo()
                       .setText(selectType);
        NetJFWatcherApplication.getSnmpV3OperationView().getSnmpValueTypeCombo()
                       .setText(selectType);

        NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText().setText(
            selectAccess);
        NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText().setText(
            selectAccess);
        NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText().setText(
            selectAccess);

        NetJFWatcherApplication.getSnmpV1OperationView().getSetValueText().setText(
            selectValue);
        NetJFWatcherApplication.getSnmpV2OperationView().getSetValueText().setText(
            selectValue);
        NetJFWatcherApplication.getSnmpV3OperationView().getSetValueText().setText(
            selectValue);

        /*
         * SNMP V1/V2/V3r[SNMP Type Combo BoxZbg
         */
        SnmpV1ValueTypeSelection.getInstance().setSnmpValueType(selectType);
        SnmpV2ValueTypeSelection.getInstance().setSnmpValueType(selectType);
        SnmpV3ValueTypeSelection.getInstance().setSnmpValueType(selectType);
    }
}
