/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionPing;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;
import netjfwatcher.engine.socket.info.PingResponseInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * Pingf[^Ot\Editor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodePingChart extends AbstractEditorNodeChart {
	/* MO */
	private static Logger logger;

	/* Pingf[^Xg */
	private ArrayList pingDataList = new ArrayList();

	/* Pingf[^ */
	private PingResponseInfo responseInfo = new PingResponseInfo();

	/**
	 * Pingf[^Ot\Editor ViewNXCX^X𐶐܂B
	 * 
	 */
	public EditorNodePingChart() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Popupj[Zbg܂B
	 * 
	 * @param parent
	 *            Popupj[zuComposite
	 */
	protected void setPopupMenu(Composite parent) {
		if (itemNameList != null) {
			popUpMenu = new Menu(parent.getShell(), SWT.POP_UP);
			canvas.setMenu(popUpMenu);

			MenuItem menuItemRefresh = new MenuItem(popUpMenu, SWT.NULL);
			menuItemRefresh.setText("Refresh");

			menuItemRefresh.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					try {
						getChartData();
					} catch (DatabaseConnectionException e1) {
						logger.warning(e1.getMessage());
						e1.printStackTrace();
					} catch (SQLException e1) {
						logger.warning(e1.getMessage());
						e1.printStackTrace();
					}

					mode = ALL_DRAW_MODE;
					selectNo = 0;
					redraw();
				}
			});
		}
	}

	/**
	 * f[^x[Xm[hPingf[^擾āAListɊi[ ܂B
	 * 
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNVڑs
	 * @throws SQLException
	 *             f[^x[XANZXُ픭
	 */
	protected void getChartData() throws DatabaseConnectionException,
			SQLException {
		if (maxData == null) {
			maxData = new String[1];
			minData = new String[1];
			dateList = new ArrayList();
			pingDataList = new ArrayList();
			allStatisticsDataList = new ArrayList();
		} else {
			dateList.clear();
			pingDataList.clear();
			allStatisticsDataList.clear();
		}

		ArrayList dataList = null;
		PingProperty property = null;

		String filterStart;
		String filterEnd;

		String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
		String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
		if (filterCheckStart == null || filterCheckStart.equals("")) {
			filterStart = null;
		} else {
			filterStart = filterCheckStart;
		}
		if (filterCheckEnd == null || filterCheckEnd.equals("")) {
			filterEnd = null;
		} else {
			filterEnd = filterCheckEnd;
		}
		int limit = DataFilterInfo.getInstance().getLimit();
		if (!isSocket) {
			DBTablePingResponse pingDBTable = DBTablePingResponse.getInstance();

			/* wԂPingf[^f[^x[X擾 */
			dataList = pingDBTable.findAll(targetNodeInfo.getIpaddress(),
					filterStart, filterEnd);
			property = pingDBTable.getDataCount(targetNodeInfo.getIpaddress());
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			try {
				ConnectionPing connectionPing = new ConnectionPing(
						engineAddress);
				PingResponseInfo pingResponseInfo = connectionPing.getPingInfo(
						targetNodeInfo.getIpaddress(), filterStart, filterEnd);

				dataList = pingResponseInfo.getPingDataList();
				property = pingResponseInfo.getPingProperty();
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + e.getMessage()
						+ " Engine=" + engineAddress);
				shell.dispose();
				e.printStackTrace();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + e.getMessage()
						+ " Engine=" + engineAddress);
				shell.dispose();
				e.printStackTrace();
			}
		}

		if ((dataList != null) && (property != null)) {
			if (dataList.size() > 0) {
				maxData[0] = property.getMaxData();
				minData[0] = property.getMinData();
			}
		}

		/* Pingf[^CX^XɃZbg */
		responseInfo.setPingDataList(dataList);
		responseInfo.setPingProperty(property);

		if (responseInfo == null) {
			return;
		}

		ArrayList workPingDataList = responseInfo.getPingDataList();

		if (workPingDataList == null) {
			return;
		}

		/*
		 * Pingf[^i[List̎ƃf[^oāA eListɊi[
		 */
		for (int i = 0; i < workPingDataList.size(); i++) {
			PingInfo pingIinfo = (PingInfo) workPingDataList.get(i);
			dateList.add(pingIinfo.getPingCheckDate().toString());
			pingDataList.add(Long.toString(pingIinfo.getPingDiffTime()));
			if (limit != 0 && i >= limit) {
				break;
			}
		}

		allStatisticsDataList.add(pingDataList);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}
}
