/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionGarbageCollectionView;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;



/**
 * GarbageCollectionWThreadƃ[f[^e[u\
 * ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class GarbageCollectionView extends ViewPart {
    /* Text */
    private static final int TEXT_WIDTH = 200;

    /* Thread AliveDescription */
    private static final String ALIVE = "Alive";

    /* Thread No AliveDescription */
    private static final String NOALIVE = "No Alive";

    /* ftHgC^[o^C}[l */
    private static final int DEFAULT_INTERVAL_TIME = 60000;

    /* MO */
    private static Logger logger;

    /* e[uJRatio */
    private static final float COLUMN0_DATE_RATIO = 0.15f;
    private static final float COLUMN1_DATA_RATIO = 0.15f;

    /* Threadԕ\Text */
    private Text treadStateText;

    /* f[^̎\Text */
    private Text treadIntervalText;

    /* ő僁[\Text */
    private Text maxMemoryText;

    /* f[^\Text */
    private Text totalDataCountText;

    /* f[^̎Jn */
    private Text collectStartDateText;

    /* f[^̎ŐV */
    private Text collectEndDateText;

    /* Free[ŏl\Text */
    private Text freeMemoryMinDataText;

    /* Free[ől\Text */
    private Text freeMemoryMaxDataText;

    /* g[^[ŏl\Text */
    private Text totalMemoryMinDataText;

    /* g[^[ől\Text */
    private Text totalMemoryMaxDataText;

    /* f[^̎Jn{^ */
    private Button startButton;

    /* f[^̎~{^ */
    private Button stopButton;

    /* \XV{^ */
    private Button refreshButton;

    /* TableViewer */
    private TableViewer viewer;

    /* Table */
    private Table memoryTable;

    /* Ot\ANVBuilder */
    private ActionBuilderChart nodeChart = new ActionBuilderChart();

    /* Ot`p̃f[^i[Xgyэ̎f[^i[Xg */
    private ArrayList<String> dateList = new ArrayList<String>();

    /* Fre[f[^i[Xg */
    private ArrayList<String> freeMemoryDataList = new ArrayList<String>();

    /* g[^f[^i[Xg */
    private ArrayList totalMemoryDataList = new ArrayList();

    /* Fre[f[^i[Xgyуg[^f[^i[Xgi[Xg */
    private ArrayList<ArrayList<String>> dataListList = new ArrayList<ArrayList<String>>();

    /* OtXg */
    private ArrayList<Object> nameList = new ArrayList<Object>();

    /* Ot`p̃f[^őlyэŏl */
    private String[] maxData = new String[2];
    private String[] minData = new String[2];

    /*
     * GWɊւANVr_[
     */
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

    /* EditorPartANV */
    private ActionBuilderEditorsPartClose actionBuilderEditorPart =
        new ActionBuilderEditorsPartClose();

    /**
     * GarbageCollectionWThreadƃ[f[^e[u\
     * ViewNXCX^X𐶐܂B
     *
     */
    public GarbageCollectionView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        gridLayout0 = new GridLayout(2, false);

        Composite subBaseComposite = new Composite(baseComposite, SWT.LEFT);
        subBaseComposite.setLayout(gridLayout0);
        subBaseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite leftComposite = new Composite(subBaseComposite, SWT.LEFT);
        leftComposite.setLayout(gridLayout);
        leftComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        gridData = new GridData();

        gridLayout = new GridLayout(1, true);

        Composite rightComposite = new Composite(subBaseComposite, SWT.FILL);
        rightComposite.setLayout(gridLayout);

        gridData =
            new GridData(
                GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL);
        rightComposite.setLayoutData(gridData);

        /* Refresh Button */
        refreshButton = new Button(leftComposite, SWT.NONE);
        refreshButton.setText("Refresh");
        refreshButton.setLayoutData(new GridData());

        /* Dummy column */
        Label label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Start Button */
        startButton = new Button(leftComposite, SWT.NONE);
        startButton.setText("Start");
        startButton.setLayoutData(new GridData());

        /* Dummy column */
        label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Stop Button */
        stopButton = new Button(leftComposite, SWT.NONE);
        stopButton.setText("Stop ");
        stopButton.setLayoutData(new GridData());

        /* Dummy column */
        label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        // LeftLayout
        label = new Label(leftComposite, SWT.NONE);
        label.setText("Thread state");
        label.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        treadStateText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        treadStateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Thread Interval(sec)");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        label.setLayoutData(gridData);
        treadIntervalText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        treadIntervalText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Max memory");
        label.setLayoutData(new GridData());
        maxMemoryText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        maxMemoryText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total data count");
        gridData = new GridData();
        label.setLayoutData(gridData);

        totalDataCountText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalDataCountText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Start date");
        label.setLayoutData(new GridData());
        collectStartDateText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        collectStartDateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("End date");
        label.setLayoutData(new GridData());
        collectEndDateText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        collectEndDateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Free memory max data");
        label.setLayoutData(new GridData());
        freeMemoryMaxDataText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        freeMemoryMaxDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Free memory min data");
        label.setLayoutData(new GridData());
        freeMemoryMinDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        freeMemoryMinDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total memory max data");
        label.setLayoutData(new GridData());
        totalMemoryMaxDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalMemoryMaxDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total memory min data");
        label.setLayoutData(new GridData());
        totalMemoryMinDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalMemoryMinDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /*
         * GarbageCollectionf[^e[u
         */
        GarbageCollectionDataTable statisticsTable =
            new GarbageCollectionDataTable();
        memoryTable = statisticsTable.createTable(rightComposite);
        viewer = new TableViewer(memoryTable);
        viewer.setUseHashlookup(true);

        /* Text\Zbg */
        setInitText();

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(800, 400);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * \XV{^Xi[
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    refreshButton.setEnabled(false);
                    getGarbageCollection();
                    refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
        * f[^̎Jn{^Xi[
        */
        startButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    startButton.setEnabled(false);
                    startGarbageCollection();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * f[^̎~{^Xi[
         */
        stopButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    stopButton.setEnabled(false);
                    stopGarbageCollection();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* ContextMenu𐶐 */
        createContextMenu();

        /* ANVo[Zbg */
        fillActionBars();
    }

    /*
     * Textݒ肵܂B
     *
     */
    private void setInitText() {
        treadIntervalText.setText("60");

        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            treadStateText.setText(ALIVE);
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        } else {
            treadStateText.setText(NOALIVE);
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }

        maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[WZbg */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {

                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /*
         * ReLXgj[𐶐Zbg
         */
        Menu menu = mm.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, viewer);
    }

    /**
     * j[o[
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* GarbageCollection[Ot\ANV */
        String title =
            "GarbageCollection " + AbstractEditorNodeChart.TITLE_SUFFIX;
        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setTitle(title);

        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setMaxData(maxData);
        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setMinData(minData);
        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setDateList(dateList);

        dataListList.clear();
        dataListList.add(freeMemoryDataList);
        dataListList.add(totalMemoryDataList);
        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setDataList(dataListList);

        nameList.clear();
        nameList.add("Free memory");
        nameList.add("Total memory");
        ((ActionGarbageCollectionView) nodeChart.getActionGarbageCollectionView())
        .setNameList(nameList);
        manager.add(nodeChart.getActionGarbageCollectionView());
    }

    /*
     * GarbageCollectionf[^WJn܂B
     *
     */
    private void startGarbageCollection() {
        GarbageCollectionControl garbageControl =
            new GarbageCollectionControl();

        /* GarbageCollectionf[^WJn */
        logger.info("GarbageCollection start");

        DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();

        try {
            gar.createTable();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } finally {
            gar = null;
        }

        int intervalTime = DEFAULT_INTERVAL_TIME;
        intervalTime = Integer.parseInt(treadIntervalText.getText()) * 1000;
        GarbageCollectionMemoryJVM.getInstance().setSleepTime(intervalTime);
        GarbageCollectionMemoryJVM.getInstance().startThread();

        /*
         * K[x[WRNVf[^̎Jn
         */
        garbageControl.setThreadState(
            GarbageCollectionMemoryJVM.getInstance().checkThread());
        garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());

        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            treadStateText.setText(ALIVE);
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        } else {
            treadStateText.setText(NOALIVE);
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }

        maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    /*
     * K[x[WRNVf[^̎悵܂B
     */
    private void getGarbageCollection() {
        GarbageCollectionControl garbageControl = null;
        ArrayList garbageCollectionDataList = null;

        logger.info("GarbageCollection get info");

        /*
         * K[x[WRNVf[^̎
         */
        DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();

        try {
            garbageCollectionDataList = gar.findAll(null, null);
            garbageControl = gar.getDataCount();
        } catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            gar = null;
        }

        if (garbageControl != null) {
            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setGarbagCollectionMemoryList(
                garbageCollectionDataList);

            long totalMemoryMaxData = garbageControl.getTotalMemoryMaxData();
            long totalMemoryMinData = garbageControl.getTotalMemoryMinData();
            long freeMemoryMaxData = garbageControl.getFreeMemoryMaxData();
            long freeMemoryMinData = garbageControl.getFreeMemoryMinData();

            if (garbageCollectionDataList != null) {
                long totalDataCount = garbageCollectionDataList.size();
                totalDataCountText.setText(Long.toString(totalDataCount));
            }

            treadIntervalText.setText(
                Long.toString(
                    GarbageCollectionMemoryJVM.getInstance().getSleepTime() / 1000));
            freeMemoryMaxDataText.setText(Long.toString(freeMemoryMaxData));
            freeMemoryMinDataText.setText(Long.toString(freeMemoryMinData));
            totalMemoryMaxDataText.setText(Long.toString(totalMemoryMaxData));
            totalMemoryMinDataText.setText(Long.toString(totalMemoryMinData));

            maxData[0] = Long.toString(freeMemoryMaxData);
            maxData[1] = Long.toString(totalMemoryMaxData);
            minData[0] = Long.toString(freeMemoryMinData);
            minData[1] = Long.toString(totalMemoryMinData);

            logger.info("maxData[0] : " + maxData[0]);
            logger.info("maxData[1] : " + maxData[1]);
            logger.info("minData[0] : " + minData[0]);
            logger.info("minData[1] : " + minData[1]);

            if (garbageControl.getStartDate() != null) {
                collectStartDateText.setText(
                    garbageControl.getStartDate().toString());
            }

            if (garbageControl.getEndDate() != null) {
                collectEndDateText.setText(
                    garbageControl.getEndDate().toString());
            }

            setTable(garbageCollectionDataList);
        }

        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            treadStateText.setText(ALIVE);
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        } else {
            treadStateText.setText(NOALIVE);
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }

        maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    /*
     * K[x[WRNVf[^̎~܂B
     */
    private void stopGarbageCollection() {
        GarbageCollectionControl garbageControl =
            new GarbageCollectionControl();

        /*
         * K[x[WRNVf[^̎~
         */
        GarbageCollectionMemoryJVM.getInstance().stopThread();

        logger.info("GarbageCollectionMemoryJVM thread stop");
        garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
        garbageControl.setThreadState(
            GarbageCollectionMemoryJVM.getInstance().checkThread());

        logger.info(
            "GarbageCollectionMemoryJVM thread stop thread State : "
            + GarbageCollectionMemoryJVM.getInstance().checkThread());

        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            treadStateText.setText(ALIVE);
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        } else {
            treadStateText.setText(NOALIVE);
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }

        maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    /**
     * tH[JXZbgꂽ̏łB
     *
     */
    public void setFocus() {
    }

    /*
     * GarbageCollection[e[uZbg܂B
     *
     * @param garbageCollectionDataList GarbageCollection[f[^Xg
     */
    private void setTable(ArrayList garbageCollectionDataList) {
        if (
            (garbageCollectionDataList == null)
                || (garbageCollectionDataList.size() < 1)) {
            return;
        }

        /* e[ȗSč폜ătbV */
        memoryTable.removeAll();
        viewer.refresh();

        dateList.clear();
        freeMemoryDataList.clear();
        totalMemoryDataList.clear();

        logger.info(
            "garbageCollectionDataList.size() : "
            + garbageCollectionDataList.size());

        for (int i = 0; i < garbageCollectionDataList.size(); i++) {
            GarbageCollectionInfo garbageCollectionInfo =
                (GarbageCollectionInfo) garbageCollectionDataList.get(i);

            String[] garbageCollectionTableCellArray = new String[3];

            garbageCollectionTableCellArray[0] =
                garbageCollectionInfo.getCheckDate().toString();
            garbageCollectionTableCellArray[1] =
                Long.toString(garbageCollectionInfo.getFreeMemory());
            garbageCollectionTableCellArray[2] =
                Long.toString(garbageCollectionInfo.getTotalMemory());

            TableItem item = new TableItem(memoryTable, SWT.NULL);

            item.setText(garbageCollectionTableCellArray);
            item.setData(garbageCollectionTableCellArray);

            dateList.add(garbageCollectionTableCellArray[0]);
            freeMemoryDataList.add(garbageCollectionTableCellArray[1]);
            totalMemoryDataList.add(garbageCollectionTableCellArray[2]);

            logger.info(
                "garbageCollectionTableCellArray[0] : "
                + garbageCollectionTableCellArray[0]);
            logger.info(
                "garbageCollectionTableCellArray[1] : "
                + garbageCollectionTableCellArray[1]);
            logger.info(
                "garbageCollectionTableCellArray[2] : "
                + garbageCollectionTableCellArray[2]);
        }
    }

    /**
     * J0if[^̎j̕Ԃ܂B
     *
     * @return J0if[^̎j̕
     */
    private int computeCol0Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN0_DATE_RATIO);
    }

    /**
     * J1iGarbageCollectionf[^j̕Ԃ܂B
     *
     * @return J1iGarbageCollectionf[^j̕
     */
    private int computeCol1Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN1_DATA_RATIO);
    }

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();

        if (memoryTable != null) {
            memoryTable.dispose();
        }
    }

    /*
     * GWɊւANVԂ܂B
     *
     * @return actionBuilderEngine GWɊւANV
     */
    private ActionBuilderEngine getEngineActionBuilder() {
        return actionBuilderEngine;
    }

    /*
     * ANVBarZbg܂B
     *
     */
    private void fillActionBars() {
        IActionBars actionBars = getViewSite().getActionBars();

        /* Engine ToolBarZbg */
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(getEngineActionBuilder().getActionStartEngine());
        toolBar.add(getEngineActionBuilder().getActionStopEngine());

        /* EditorPart CloseANV */
        toolBar.add(actionBuilderEditorPart.actionCloseAllEditors());
    }

    /**
     * GarbageCollectionf[^e[u viewNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class GarbageCollectionDataTable extends AbstractTableView {
        /* e[ůeJ\[g */
        private boolean[] isColDirection;

        /*
         * Pingf[^\e[u𐶐ĕԂ܂B
         *
         * @return table Table
         */
        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = GridData.FILL;
            data2.verticalAlignment = GridData.FILL;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;

            /* e[uZbg */
            table =
                new Table(
                    parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            table.setLayoutData(data2);

            isColDirection = new boolean[3];

            TableColumn[] col = new TableColumn[3];

            col[0] = new TableColumn(table, SWT.CENTER);
            col[0].setText("Date");
            col[0].setWidth(computeCol0Width());
            isColDirection[0] = true;

            col[0].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event event) {

                        /* J\[gA\[gێ */
                        isColDirection[0] =
                            sortTable(table, 0, isColDirection[0]);
                    }
                });

            col[1] = new TableColumn(table, SWT.CENTER);
            col[1].setText("Free memory");
            col[1].setWidth(computeCol1Width());
            isColDirection[1] = true;

            col[1].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event event) {
                        /* J\[gA\[gێ */
                        isColDirection[1] =
                            sortIntegerTable(table, 1, isColDirection[1]);
                    }
                });

            col[2] = new TableColumn(table, SWT.CENTER);
            col[2].setText("Total memory");
            col[2].setWidth(computeCol0Width());
            isColDirection[2] = true;

            col[2].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event event) {
                        /* J\[gA\[gێ */
                        isColDirection[2] =
                            sortIntegerTable(table, 2, isColDirection[2]);
                    }
                });

            /*
             * e[uړꍇ͂TCYꍇ̃Xi[łB
             *
             */
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
                      .addControlListener(
                new ControlListener() {
                    public void controlMoved(ControlEvent event) {
                    }

                    public void controlResized(ControlEvent event) {
                    }
                });

            return table;
        }
        
        protected void setResizedTableColumnWidth() {
        	
        }
    }
}
